/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils.mpi.utils;

import dev.vality.adapter.common.utils.mpi.exception.ThreeDSecureException;
import dev.vality.adapter.common.utils.mpi.model.Message;
import dev.vality.adapter.common.utils.mpi.model.PaRes;
import dev.vality.adapter.common.utils.mpi.model.TX;
import dev.vality.adapter.common.utils.mpi.model.ThreeDSecure;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreeDSecureUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreeDSecureUtils.class);
    private static JAXBContext jaxbContext;

    public static ThreeDSecure extractThreeDSecure(String str) {
        try {
            Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(str);
            return (ThreeDSecure)jaxbMarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException ex) {
            log.error("Can't extract ThreeDSecure", (Throwable)ex);
            throw new ThreeDSecureException(ex);
        }
    }

    public static String extractEciFromPaRes(ThreeDSecure threeDSecure) {
        return Optional.ofNullable(threeDSecure).map(ThreeDSecure::getMessage).map(Message::getPaRes).map(PaRes::getTx).map(TX::getEci).orElse("");
    }

    private ThreeDSecureUtils() {
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ThreeDSecure.class});
        }
        catch (JAXBException ex) {
            log.error("Failed to create jaxb context", (Throwable)ex);
            throw new RuntimeException("Failed to create jaxb context", ex);
        }
    }
}

