/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils.mpi.utils;

import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncompressDecoder {
    private static final Logger log = LoggerFactory.getLogger(UncompressDecoder.class);
    private static final int START_OFFSET_IN_DATA = 0;

    public static String decodePaRes(String str) {
        return UncompressDecoder.decode(str);
    }

    public static String decode(String str) {
        byte[] decode = Base64.getDecoder().decode(str.getBytes());
        return new String(UncompressDecoder.gzuncompress(decode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] gzuncompress(byte[] data) {
        byte[] unCompressed = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        Inflater deCompressor = new Inflater();
        try {
            deCompressor.setInput(data);
            byte[] buf = new byte[1024];
            while (!deCompressor.finished()) {
                int count = deCompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            unCompressed = bos.toByteArray();
            bos.close();
        }
        catch (Exception e) {
            log.error("UnCompress Exception", (Throwable)e);
        }
        finally {
            deCompressor.end();
        }
        return unCompressed;
    }
}

