/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.flow;

import dev.vality.adapter.flow.lib.constant.Step;
import dev.vality.adapter.flow.lib.constant.TargetStatus;
import dev.vality.adapter.flow.lib.flow.StepResolver;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.utils.StageFlowResolver;

public abstract class AbstractPaymentStepResolver<T extends EntryStateModel, R extends ExitStateModel>
implements StepResolver<T, R> {
    @Override
    public Step resolveCurrentStep(T entryStateModel) {
        Step currentStep = ((EntryStateModel)entryStateModel).getCurrentStep();
        if (currentStep != null) {
            return currentStep;
        }
        return switch (((EntryStateModel)entryStateModel).getTargetStatus()) {
            case TargetStatus.PROCESSED -> {
                if (StageFlowResolver.isOneStageFlow(entryStateModel)) {
                    yield Step.PAY;
                }
                yield Step.AUTH;
            }
            case TargetStatus.CAPTURED -> {
                if (StageFlowResolver.isOneStageFlow(entryStateModel)) {
                    yield Step.DO_NOTHING;
                }
                yield Step.CAPTURE;
            }
            case TargetStatus.CANCELLED -> Step.CANCEL;
            case TargetStatus.REFUNDED -> Step.REFUND;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

