/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.flow.full;

import dev.vality.adapter.flow.lib.constant.Step;
import dev.vality.adapter.flow.lib.flow.ResultIntentResolver;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.service.IntentResultFactory;
import dev.vality.damsel.proxy_provider.Intent;
import dev.vality.java.damsel.utils.creators.ProxyProviderPackageCreators;

public class ResultIntentResolverImpl
implements ResultIntentResolver {
    private final IntentResultFactory intentResultFactory;

    @Override
    public Intent initIntentByStep(ExitStateModel exitStateModel) {
        Step nextStep = exitStateModel.getNextStep();
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        Step currentStep = entryStateModel.getCurrentStep();
        return switch (nextStep) {
            case Step.FINISH_THREE_DS_V1, Step.CHECK_NEED_3DS_V2, Step.FINISH_THREE_DS_V2 -> this.intentResultFactory.createSuspendIntentWithFailedAfterTimeout(exitStateModel);
            case Step.DO_NOTHING -> this.createIntentByCurrentStep(exitStateModel, currentStep);
            case Step.CAPTURE, Step.REFUND, Step.CANCEL -> ProxyProviderPackageCreators.createFinishIntentSuccess();
            default -> throw new IllegalStateException("Wrong nextStep: " + nextStep);
        };
    }

    private Intent createIntentByCurrentStep(ExitStateModel exitStateModel, Step currentStep) {
        return switch (currentStep) {
            case Step.FINISH_THREE_DS_V1, Step.CHECK_NEED_3DS_V2, Step.FINISH_THREE_DS_V2, Step.DO_NOTHING, Step.CAPTURE, Step.PAY, Step.AUTH -> this.intentResultFactory.createFinishIntentSuccessWithCheckToken(exitStateModel);
            case Step.REFUND, Step.CANCEL -> ProxyProviderPackageCreators.createFinishIntentSuccess();
            default -> throw new IllegalStateException("Wrong currentStep: " + currentStep);
        };
    }

    public ResultIntentResolverImpl(IntentResultFactory intentResultFactory) {
        this.intentResultFactory = intentResultFactory;
    }
}

