/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.handler;

import dev.vality.adapter.flow.lib.handler.CommonHandler;
import dev.vality.adapter.flow.lib.processor.Processor;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public abstract class CommonHandlerImpl<P, R, E, T>
implements CommonHandler<T, E> {
    private static final Logger log = LoggerFactory.getLogger(CommonHandlerImpl.class);
    private final Function<P, R> requestFunction;
    private final Converter<E, P> converter;
    private final Processor<T, R, E> processor;

    @Override
    public T handle(E entryStateModel) {
        Object request = this.converter.convert(entryStateModel);
        R response = this.requestFunction.apply(request);
        return this.processor.process(response, entryStateModel);
    }

    public CommonHandlerImpl(Function<P, R> requestFunction, Converter<E, P> converter, Processor<T, R, E> processor) {
        this.requestFunction = requestFunction;
        this.converter = converter;
        this.processor = processor;
    }
}

