/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.service;

import dev.vality.adapter.flow.lib.constant.RedirectFields;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.model.PollingInfo;
import dev.vality.adapter.flow.lib.model.ThreeDsData;
import dev.vality.adapter.flow.lib.service.ExponentialBackOffPollingService;
import dev.vality.adapter.flow.lib.service.PollingInfoService;
import dev.vality.adapter.flow.lib.service.TagManagementService;
import dev.vality.adapter.flow.lib.utils.CallbackUrlExtractor;
import dev.vality.adapter.flow.lib.utils.ThreeDsDataInitializer;
import dev.vality.adapter.flow.lib.utils.TimeoutUtils;
import dev.vality.adapter.flow.lib.utils.TimerProperties;
import dev.vality.damsel.base.Timer;
import dev.vality.damsel.domain.Failure;
import dev.vality.damsel.proxy_provider.RecurrentTokenFinishIntent;
import dev.vality.damsel.proxy_provider.RecurrentTokenFinishStatus;
import dev.vality.damsel.proxy_provider.RecurrentTokenIntent;
import dev.vality.damsel.proxy_provider.SleepIntent;
import dev.vality.damsel.proxy_provider.SuspendIntent;
import dev.vality.error.mapping.ErrorMapping;
import dev.vality.java.damsel.utils.creators.ProxyProviderPackageCreators;
import dev.vality.java.damsel.utils.extractors.OptionsExtractors;
import java.util.Map;

public class RecurrentIntentResultFactory {
    private final TimerProperties timerProperties;
    private final CallbackUrlExtractor callbackUrlExtractor;
    private final TagManagementService tagManagementService;
    private final PollingInfoService pollingInfoService;
    private final ErrorMapping errorMapping;
    private final ExponentialBackOffPollingService exponentialBackOffPollingService;

    public RecurrentTokenIntent createIntentWithSuspension(ExitStateModel exitStateModel) {
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        ThreeDsData threeDsData = exitStateModel.getThreeDsData();
        Map<String, String> params = ThreeDsDataInitializer.initThreeDsParameters(exitStateModel);
        String redirectUrl = entryStateModel.getBaseRequestModel().getSuccessRedirectUrl();
        params.put(RedirectFields.TERM_URL.getValue(), this.callbackUrlExtractor.extractCallbackUrl(redirectUrl));
        int timerRedirectTimeoutMin = OptionsExtractors.extractRedirectTimeout(entryStateModel.getBaseRequestModel().getAdapterConfigurations(), (int)this.timerProperties.getRedirectTimeoutMin());
        return RecurrentTokenIntent.suspend((SuspendIntent)new SuspendIntent(this.tagManagementService.findTag(params), Timer.timeout((int)TimeoutUtils.toSeconds(timerRedirectTimeoutMin))).setUserInteraction(ProxyProviderPackageCreators.createPostUserInteraction((String)threeDsData.getAcsUrl(), params)));
    }

    public RecurrentTokenIntent createSleepIntentForReinvocation() {
        return RecurrentTokenIntent.sleep((SleepIntent)new SleepIntent(Timer.timeout((int)0)));
    }

    public RecurrentTokenIntent createSleepIntentWithExponentialPolling(ExitStateModel exitStateModel) {
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        PollingInfo pollingInfo = this.pollingInfoService.initPollingInfo(entryStateModel);
        if (this.pollingInfoService.isDeadline(pollingInfo)) {
            return this.createFinishIntentFailed("Sleep timeout", "Max time pool limit reached");
        }
        exitStateModel.setPollingInfo(pollingInfo);
        Map<String, String> adapterConfigurations = entryStateModel.getBaseRequestModel().getAdapterConfigurations();
        int nextTimeoutSec = this.exponentialBackOffPollingService.prepareNextPollingInterval(pollingInfo, adapterConfigurations);
        return RecurrentTokenIntent.sleep((SleepIntent)new SleepIntent(Timer.timeout((int)nextTimeoutSec)));
    }

    public RecurrentTokenIntent createFinishIntent(String recToken) {
        return RecurrentTokenIntent.finish((RecurrentTokenFinishIntent)ProxyProviderPackageCreators.createRecurrentTokenStatusSuccess((String)recToken));
    }

    public RecurrentTokenIntent createFinishIntentFailed(String errorCode, String errorMessage) {
        return RecurrentTokenIntent.finish((RecurrentTokenFinishIntent)new RecurrentTokenFinishIntent(RecurrentTokenFinishStatus.failure((Failure)this.errorMapping.mapFailure(errorCode, errorMessage))));
    }

    public RecurrentIntentResultFactory(TimerProperties timerProperties, CallbackUrlExtractor callbackUrlExtractor, TagManagementService tagManagementService, PollingInfoService pollingInfoService, ErrorMapping errorMapping, ExponentialBackOffPollingService exponentialBackOffPollingService) {
        this.timerProperties = timerProperties;
        this.callbackUrlExtractor = callbackUrlExtractor;
        this.tagManagementService = tagManagementService;
        this.pollingInfoService = pollingInfoService;
        this.errorMapping = errorMapping;
        this.exponentialBackOffPollingService = exponentialBackOffPollingService;
    }
}

