/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.handler;

import dev.vality.adapter.flow.lib.handler.ServerFlowHandler;
import dev.vality.adapter.flow.lib.handler.callback.CallbackHandler;
import dev.vality.adapter.flow.lib.validator.AdapterConfigurationValidator;
import dev.vality.damsel.proxy_provider.PaymentCallbackResult;
import dev.vality.damsel.proxy_provider.PaymentContext;
import dev.vality.damsel.proxy_provider.PaymentProxyResult;
import dev.vality.damsel.proxy_provider.ProviderProxySrv;
import dev.vality.damsel.proxy_provider.RecurrentTokenCallbackResult;
import dev.vality.damsel.proxy_provider.RecurrentTokenContext;
import dev.vality.damsel.proxy_provider.RecurrentTokenProxyResult;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyProviderServiceImpl
implements ProviderProxySrv.Iface {
    private static final Logger log = LoggerFactory.getLogger(ProxyProviderServiceImpl.class);
    private final CallbackHandler<PaymentCallbackResult, PaymentContext> paymentCallbackHandler;
    private final CallbackHandler<RecurrentTokenCallbackResult, RecurrentTokenContext> recurrentTokenCallbackHandler;
    private final ServerFlowHandler<PaymentContext, PaymentProxyResult> serverFlowHandler;
    private final ServerFlowHandler<RecurrentTokenContext, RecurrentTokenProxyResult> generateTokenFlowHandler;
    private final AdapterConfigurationValidator adapterConfigurationValidator;

    public RecurrentTokenProxyResult generateToken(RecurrentTokenContext context) throws TException {
        this.adapterConfigurationValidator.validate(context.getOptions());
        return this.generateTokenFlowHandler.handle(context);
    }

    public RecurrentTokenCallbackResult handleRecurrentTokenCallback(ByteBuffer byteBuffer, RecurrentTokenContext context) throws TException {
        return this.recurrentTokenCallbackHandler.handleCallback(byteBuffer, context);
    }

    public PaymentProxyResult processPayment(PaymentContext context) throws TException {
        this.adapterConfigurationValidator.validate(context.getOptions());
        return this.serverFlowHandler.handle(context);
    }

    public PaymentCallbackResult handlePaymentCallback(ByteBuffer byteBuffer, PaymentContext context) throws TException {
        return this.paymentCallbackHandler.handleCallback(byteBuffer, context);
    }

    public ProxyProviderServiceImpl(CallbackHandler<PaymentCallbackResult, PaymentContext> paymentCallbackHandler, CallbackHandler<RecurrentTokenCallbackResult, RecurrentTokenContext> recurrentTokenCallbackHandler, ServerFlowHandler<PaymentContext, PaymentProxyResult> serverFlowHandler, ServerFlowHandler<RecurrentTokenContext, RecurrentTokenProxyResult> generateTokenFlowHandler, AdapterConfigurationValidator adapterConfigurationValidator) {
        this.paymentCallbackHandler = paymentCallbackHandler;
        this.recurrentTokenCallbackHandler = recurrentTokenCallbackHandler;
        this.serverFlowHandler = serverFlowHandler;
        this.generateTokenFlowHandler = generateTokenFlowHandler;
        this.adapterConfigurationValidator = adapterConfigurationValidator;
    }
}

