/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.processor;

import dev.vality.adapter.flow.lib.constant.Status;
import dev.vality.adapter.flow.lib.model.BaseResponseModel;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.processor.Processor;
import dev.vality.adapter.flow.lib.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryProcessor
implements Processor<ExitStateModel, BaseResponseModel, EntryStateModel> {
    private static final Logger log = LoggerFactory.getLogger(RetryProcessor.class);
    private final Processor<ExitStateModel, BaseResponseModel, EntryStateModel> nextProcessor;

    @Override
    public ExitStateModel process(BaseResponseModel response, EntryStateModel entryStateModel) {
        if (response.getStatus() == Status.NEED_RETRY && !ErrorUtils.isError(response)) {
            log.debug("Start redirect process response: {} entryStateModel: {}", (Object)response, (Object)entryStateModel);
            ExitStateModel exitStateModel = new ExitStateModel();
            exitStateModel.setLastOperationStatus(response.getStatus());
            exitStateModel.setProviderTrxId(entryStateModel.getBaseRequestModel().getProviderTrxId());
            exitStateModel.setTrxExtra(response.getSaveData());
            log.debug("Finish redirect process response: {} entryStateModel: {}", (Object)response, (Object)entryStateModel);
            return exitStateModel;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(response, entryStateModel);
        }
        throw new IllegalStateException("Processor didn't match for response " + response);
    }

    public RetryProcessor(Processor<ExitStateModel, BaseResponseModel, EntryStateModel> nextProcessor) {
        this.nextProcessor = nextProcessor;
    }
}

