/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.service;

import dev.vality.adapter.flow.lib.model.TemporaryContext;
import dev.vality.adapter.flow.lib.serde.Deserializer;
import dev.vality.adapter.flow.lib.serde.ParametersDeserializer;
import dev.vality.damsel.proxy_provider.PaymentContext;
import dev.vality.damsel.proxy_provider.RecurrentTokenContext;
import java.nio.ByteBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryContextService {
    private static final Logger log = LoggerFactory.getLogger(TemporaryContextService.class);
    private final ParametersDeserializer parametersDeserializer;

    public TemporaryContext getTemporaryContext(Object context, Deserializer<TemporaryContext> deserializer) {
        byte[] state = TemporaryContextService.getState(context);
        if (state != null && state.length > 0) {
            return deserializer.read(state);
        }
        return new TemporaryContext();
    }

    public TemporaryContext appendThreeDsParametersToContext(ByteBuffer callback, TemporaryContext temporaryContext) {
        if (callback != null && callback.hasArray() && callback.array().length > 0) {
            Object parameters = this.parametersDeserializer.read(callback.array());
            if (temporaryContext != null) {
                temporaryContext.setThreeDsData((Map<String, String>)parameters);
            } else if (parameters == null || parameters.isEmpty()) {
                throw new RuntimeException("Unknown parameters or baseModel!");
            }
        }
        log.info("TemporaryContext: {} after callback.", (Object)temporaryContext);
        return temporaryContext;
    }

    private static byte[] getState(Object context) {
        if (context instanceof RecurrentTokenContext) {
            if (((RecurrentTokenContext)context).getSession() == null) {
                return new byte[0];
            }
            return ((RecurrentTokenContext)context).getSession().getState();
        }
        return ((PaymentContext)context).getSession().getState();
    }

    public TemporaryContextService(ParametersDeserializer parametersDeserializer) {
        this.parametersDeserializer = parametersDeserializer;
    }
}

