/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.converter.exit;

import dev.vality.adapter.flow.lib.converter.ExitStateModelToTemporaryContextConverter;
import dev.vality.adapter.flow.lib.flow.ResultIntentResolver;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.serde.TemporaryContextSerializer;
import dev.vality.adapter.flow.lib.service.IntentResultFactory;
import dev.vality.adapter.flow.lib.utils.AdditionalInfoUtils;
import dev.vality.damsel.domain.TransactionInfo;
import dev.vality.damsel.proxy_provider.Intent;
import dev.vality.damsel.proxy_provider.PaymentProxyResult;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

public class ExitModelToProxyResultConverter
implements Converter<ExitStateModel, PaymentProxyResult> {
    private static final Logger log = LoggerFactory.getLogger(ExitModelToProxyResultConverter.class);
    private final IntentResultFactory intentResultFactory;
    private final TemporaryContextSerializer serializer;
    private final ResultIntentResolver resultIntentResolver;
    private final ExitStateModelToTemporaryContextConverter contextConverter;

    public PaymentProxyResult convert(ExitStateModel exitStateModel) {
        if (StringUtils.hasText((String)exitStateModel.getErrorCode())) {
            return new PaymentProxyResult(this.intentResultFactory.createFinishIntentFailed(exitStateModel));
        }
        Intent intent = this.resultIntentResolver.initIntentByStep(exitStateModel);
        return new PaymentProxyResult(intent).setNextState(this.serializer.writeByte(this.contextConverter.convert(exitStateModel))).setTrx(new TransactionInfo().setId(exitStateModel.getProviderTrxId()).setExtra(exitStateModel.getTrxExtra() != null ? exitStateModel.getTrxExtra() : new HashMap()).setAdditionalInfo(AdditionalInfoUtils.initAdditionalTrxInfo(exitStateModel)));
    }

    public ExitModelToProxyResultConverter(IntentResultFactory intentResultFactory, TemporaryContextSerializer serializer, ResultIntentResolver resultIntentResolver, ExitStateModelToTemporaryContextConverter contextConverter) {
        this.intentResultFactory = intentResultFactory;
        this.serializer = serializer;
        this.resultIntentResolver = resultIntentResolver;
        this.contextConverter = contextConverter;
    }
}

