/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.handler;

import dev.vality.adapter.flow.lib.exception.UnknownHandlerForStepException;
import dev.vality.adapter.flow.lib.flow.StepResolver;
import dev.vality.adapter.flow.lib.handler.CommonHandler;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import java.util.List;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class ServerFlowHandler<T, R> {
    private static final Logger log = LoggerFactory.getLogger(ServerFlowHandler.class);
    private final List<CommonHandler<ExitStateModel, EntryStateModel>> handlers;
    private final StepResolver<EntryStateModel, ExitStateModel> stepResolver;
    private final Converter<T, EntryStateModel> entryConverter;
    private final Converter<ExitStateModel, R> exitConverter;

    public R handle(T context) throws TException {
        EntryStateModel entryStateModel = this.prepareEntryState(this.entryConverter, context);
        log.info("EntryStateModel: {}", (Object)entryStateModel);
        ExitStateModel exitStateModel = (ExitStateModel)this.handlers.stream().filter(handler -> handler.isHandle(entryStateModel)).findFirst().orElseThrow(() -> new UnknownHandlerForStepException("Can't find handler to data: " + entryStateModel)).handle(entryStateModel);
        log.info("ExitStateModel: {}", (Object)exitStateModel);
        exitStateModel.setEntryStateModel(entryStateModel);
        exitStateModel.setNextStep(this.stepResolver.resolveNextStep(exitStateModel));
        log.info("Step changing: {} -> {}", (Object)entryStateModel.getCurrentStep(), (Object)exitStateModel.getNextStep());
        return (R)this.exitConverter.convert((Object)exitStateModel);
    }

    private EntryStateModel prepareEntryState(Converter<T, EntryStateModel> entryConverter, T context) {
        EntryStateModel entryStateModel = (EntryStateModel)entryConverter.convert(context);
        entryStateModel.setCurrentStep(this.stepResolver.resolveCurrentStep(entryStateModel));
        return entryStateModel;
    }

    public ServerFlowHandler(List<CommonHandler<ExitStateModel, EntryStateModel>> handlers, StepResolver<EntryStateModel, ExitStateModel> stepResolver, Converter<T, EntryStateModel> entryConverter, Converter<ExitStateModel, R> exitConverter) {
        this.handlers = handlers;
        this.stepResolver = stepResolver;
        this.entryConverter = entryConverter;
        this.exitConverter = exitConverter;
    }
}

