/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.processor;

import dev.vality.adapter.flow.lib.model.BaseResponseModel;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.processor.Processor;
import dev.vality.adapter.flow.lib.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorProcessor
implements Processor<ExitStateModel, BaseResponseModel, EntryStateModel> {
    private static final Logger log = LoggerFactory.getLogger(ErrorProcessor.class);

    @Override
    public ExitStateModel process(BaseResponseModel response, EntryStateModel entryStateModel) {
        log.debug("Start error process response: {} entryStateModel: {}", (Object)response, (Object)entryStateModel);
        if (response != null && ErrorUtils.isError(response)) {
            ExitStateModel exitStateModel = new ExitStateModel();
            exitStateModel.setErrorCode(String.valueOf(response.getErrorCode()));
            exitStateModel.setErrorMessage(response.getErrorMessage());
            exitStateModel.setAdditionalTrxInfo(response.getAdditionalTrxInfo());
            log.debug("Finish error process response: {} entryStateModel: {}", (Object)response, (Object)entryStateModel);
            return exitStateModel;
        }
        ExitStateModel exitStateModel = new ExitStateModel();
        exitStateModel.setErrorCode("unknown_error");
        exitStateModel.setErrorMessage("Unknown error reason!");
        exitStateModel.setEntryStateModel(entryStateModel);
        log.debug("Finish error process response: {} entryStateModel: {}", (Object)response, (Object)entryStateModel);
        return exitStateModel;
    }
}

