/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.serde;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.vality.adapter.flow.lib.exception.DeserializationException;
import dev.vality.adapter.flow.lib.serde.Deserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class ParametersDeserializer
implements Deserializer<Map<String, String>> {
    private final ObjectMapper mapper;

    @Override
    public Map<String, String> read(byte[] data) {
        if (data == null) {
            return new HashMap<String, String>();
        }
        try {
            return (Map)this.mapper.readValue(data, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        }
        catch (IOException var3) {
            throw new IllegalArgumentException(var3);
        }
    }

    @Override
    public Map<String, String> read(String data) {
        throw new DeserializationException("Deserialization not supported");
    }

    public Map<String, String> read(HttpServletRequest request) {
        return Optional.ofNullable(request.getParameterMap()).orElseGet(HashMap::new).entrySet().stream().collect(Collectors.toMap(k -> ((String)k.getKey()).trim(), v -> ((String[])v.getValue())[0]));
    }

    public ParametersDeserializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

