/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.trace;

import dev.vality.woody.api.flow.error.WErrorDefinition;
import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.api.trace.Metadata;
import dev.vality.woody.api.trace.Span;
import dev.vality.woody.api.trace.context.TraceContext;
import dev.vality.woody.api.trace.context.metadata.MetadataExtension;
import java.time.Instant;
import java.util.function.Function;

public class ContextUtils {
    public static <T> T createErrIfNotIntercepted(ContextSpan span, Function<Throwable, T> errConstructor) {
        Throwable err = ContextUtils.getInterceptionError(span);
        if (err != null) {
            return errConstructor.apply(err);
        }
        return null;
    }

    public static Throwable getInterceptionError(ContextSpan span) {
        return ContextUtils.getMetadataValue(span, Throwable.class, "md_interception_error");
    }

    public static void setInterceptionError(ContextSpan span, Throwable t) {
        span.getMetadata().putValue("md_interception_error", t);
    }

    public static void setInterceptionErrorReason(ContextSpan span, Object reason) {
        span.getMetadata().putValue("md_interception_error_reason", reason);
    }

    public static <T> T getInterceptionErrorReason(ContextSpan span, Class<T> targetType) {
        return ContextUtils.getMetadataValue(span, targetType, "md_interception_error_reason");
    }

    public static void setCallError(ContextSpan span, Throwable t) {
        span.getMetadata().putValue("md_call_error", t);
    }

    public static Throwable getCallError(ContextSpan span) {
        return ContextUtils.getMetadataValue(span, Throwable.class, "md_call_error");
    }

    public static boolean hasCallErrors(ContextSpan span) {
        return span.getMetadata().containsKey("md_call_error");
    }

    public static WErrorDefinition getErrorDefinition(ContextSpan span) {
        return (WErrorDefinition)span.getMetadata().getValue("md_error_def");
    }

    public static Instant getDeadline(ContextSpan contextSpan) {
        Span span = contextSpan.getSpan();
        if (span.hasDeadline()) {
            return span.getDeadline();
        }
        return null;
    }

    public static void setDeadline(Instant deadline) {
        ContextUtils.setDeadline(TraceContext.getCurrentTraceData().getClientSpan(), deadline);
    }

    public static void setDeadline(ContextSpan span, Instant deadline) {
        if (deadline != null) {
            span.getSpan().setDeadline(deadline);
        }
    }

    public static int getExecutionTimeout(ContextSpan span, int defaultTimeout) {
        Instant deadline = ContextUtils.getDeadline(span);
        if (deadline != null) {
            int executionTimeout = Math.toIntExact(deadline.toEpochMilli() - System.currentTimeMillis());
            return Math.max(executionTimeout, 0);
        }
        return defaultTimeout;
    }

    public static void tryThrowInterceptionError(ContextSpan span) throws Throwable {
        Throwable t = ContextUtils.getInterceptionError(span);
        if (t != null) {
            throw t;
        }
    }

    public static <T, TT extends T> void setCustomMetadataValue(TT val, MetadataExtension<T> extension) {
        extension.setValue(val, TraceContext.getCurrentTraceData().getActiveSpan().getCustomMetadata());
    }

    public static <T, TT extends T> void setCustomMetadataValue(String key, TT val, MetadataExtension<T> extension) {
        extension.setValue(key, val, TraceContext.getCurrentTraceData().getActiveSpan().getCustomMetadata());
    }

    public static Object setCustomMetadataValue(String key, Object val) {
        return TraceContext.getCurrentTraceData().getActiveSpan().getCustomMetadata().putValue(key, val);
    }

    public static <T> T getCustomMetadataValue(MetadataExtension<T> extension) {
        return extension.getValue(TraceContext.getCurrentTraceData().getActiveSpan().getCustomMetadata());
    }

    public static <T> T getCustomMetadataValue(String key, MetadataExtension<T> extension) {
        return extension.getValue(key, TraceContext.getCurrentTraceData().getActiveSpan().getCustomMetadata());
    }

    public static <T> T getCustomMetadataValue(Class<T> targetType, String key) {
        return ContextUtils.getCustomMetadataValue(TraceContext.getCurrentTraceData().getActiveSpan(), targetType, key);
    }

    public static <T> T getCustomMetadataValue(ContextSpan span, Class<T> targetType, String key) {
        return ContextUtils.getMetadataValue(span.getCustomMetadata(), targetType, key);
    }

    public static <T> T getMetadataValue(Class<T> targetType, String key) {
        return ContextUtils.getMetadataValue(TraceContext.getCurrentTraceData().getActiveSpan(), targetType, key);
    }

    public static <T> T getMetadataValue(ContextSpan span, Class<T> targetType, String key) {
        return ContextUtils.getMetadataValue(span.getMetadata(), targetType, key);
    }

    public static <T> T getMetadataValue(Metadata metadata, Class<T> targetType, String key) {
        Object obj = metadata.getValue(key);
        if (obj == null) {
            return null;
        }
        if (targetType.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        return null;
    }

    public static <T> T getContextValue(Class<T> targetType, Object[] params, int index) {
        if (params == null || params.length <= index || params[index] == null) {
            return null;
        }
        if (targetType.isAssignableFrom(params[index].getClass())) {
            return (T)params[index];
        }
        return null;
    }
}

