/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.trace;

import java.time.Instant;

public class Span {
    private String traceId;
    private String name;
    private String id;
    private String parentId;
    private Instant deadline;
    private long timestamp;
    private long duration;

    public Span() {
    }

    protected Span(Span oldSpan) {
        this.traceId = oldSpan.traceId;
        this.name = oldSpan.name;
        this.id = oldSpan.id;
        this.parentId = oldSpan.parentId;
        this.deadline = oldSpan.deadline;
        this.timestamp = oldSpan.timestamp;
        this.duration = oldSpan.duration;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Instant getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Instant deadline) {
        this.deadline = deadline;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean isFilled() {
        return this.traceId != null && this.parentId != null && this.id != null;
    }

    public boolean isStarted() {
        return this.isFilled() && this.timestamp != 0L;
    }

    public boolean hasDeadline() {
        return this.deadline != null;
    }

    public void reset() {
        this.traceId = null;
        this.name = null;
        this.id = null;
        this.parentId = null;
        this.deadline = null;
        this.timestamp = 0L;
        this.duration = 0L;
    }

    public Span cloneObject() {
        return new Span(this);
    }

    public String toString() {
        return "Span{traceId='" + this.traceId + '\'' + ", name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", parentId='" + this.parentId + '\'' + ", deadline=" + this.deadline + ", timestamp=" + this.timestamp + ", duration=" + this.duration + '}';
    }
}

