/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.trace;

import dev.vality.woody.api.trace.ClientSpan;
import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.api.trace.ServiceSpan;

public class TraceData {
    private final ClientSpan clientSpan;
    private final ServiceSpan serviceSpan;

    public TraceData() {
        this.clientSpan = new ClientSpan();
        this.serviceSpan = new ServiceSpan();
    }

    public TraceData(TraceData oldTraceData) {
        this(oldTraceData, false);
    }

    public TraceData(TraceData oldTraceData, boolean copyCustomServiceMetadata) {
        this.clientSpan = copyCustomServiceMetadata ? new ClientSpan(oldTraceData.clientSpan, oldTraceData.serviceSpan.customMetadata) : oldTraceData.clientSpan.cloneObject();
        this.serviceSpan = oldTraceData.serviceSpan.cloneObject();
    }

    public ClientSpan getClientSpan() {
        return this.clientSpan;
    }

    public ServiceSpan getServiceSpan() {
        return this.serviceSpan;
    }

    public boolean isRoot() {
        return !this.serviceSpan.isFilled();
    }

    public boolean isClient() {
        return !this.serviceSpan.isFilled() || this.clientSpan.isFilled();
    }

    public ContextSpan getActiveSpan() {
        return this.isClient() ? this.clientSpan : this.serviceSpan;
    }

    public ContextSpan getSpan(boolean isClient) {
        return isClient ? this.clientSpan : this.serviceSpan;
    }

    public void reset() {
        this.clientSpan.reset();
        this.serviceSpan.reset();
    }

    public TraceData cloneObject() {
        return new TraceData(this);
    }
}

