/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.trace.context;

import dev.vality.woody.api.MDCUtils;
import dev.vality.woody.api.generator.IdGenerator;
import dev.vality.woody.api.trace.Span;
import dev.vality.woody.api.trace.TraceData;
import java.util.Optional;

public class TraceContext {
    public static final String NO_PARENT_ID = "undefined";
    private static final ThreadLocal<TraceData> currentTraceData = ThreadLocal.withInitial(TraceData::new);
    private static final ThreadLocal<TraceData> savedTraceData = new ThreadLocal();
    private final IdGenerator traceIdGenerator;
    private final IdGenerator spanIdGenerator;
    private final Runnable postInit;
    private final Runnable preDestroy;
    private final Runnable preErrDestroy;
    private final boolean isAuto;
    private final boolean isClient;

    public TraceContext(IdGenerator idGenerator) {
        this(idGenerator, idGenerator);
    }

    public TraceContext(IdGenerator traceIdGenerator, IdGenerator spanIdGenerator) {
        this(traceIdGenerator, spanIdGenerator, () -> {}, () -> {}, () -> {});
    }

    public TraceContext(IdGenerator idGenerator, Runnable postInit, Runnable preDestroy, Runnable preErrDestroy) {
        this(idGenerator, idGenerator, postInit, preDestroy, preErrDestroy);
    }

    public TraceContext(IdGenerator traceIdGenerator, IdGenerator spanIdGenerator, Runnable postInit, Runnable preDestroy, Runnable preErrDestroy) {
        this(traceIdGenerator, spanIdGenerator, postInit, preDestroy, preErrDestroy, Optional.empty());
    }

    public TraceContext(IdGenerator idGenerator, Runnable postInit, Runnable preDestroy, Runnable preErrDestroy, boolean isClient) {
        this(idGenerator, idGenerator, postInit, preDestroy, preErrDestroy, Optional.of(isClient));
    }

    private TraceContext(IdGenerator traceIdGenerator, IdGenerator spanIdGenerator, Runnable postInit, Runnable preDestroy, Runnable preErrDestroy, Optional<Boolean> isClient) {
        this.traceIdGenerator = traceIdGenerator;
        this.spanIdGenerator = spanIdGenerator;
        this.postInit = postInit;
        this.preDestroy = preDestroy;
        this.preErrDestroy = preErrDestroy;
        if (isClient.isPresent()) {
            this.isAuto = false;
            this.isClient = isClient.get();
        } else {
            this.isAuto = true;
            this.isClient = false;
        }
    }

    public static TraceData getCurrentTraceData() {
        return currentTraceData.get();
    }

    public static void setCurrentTraceData(TraceData traceData) {
        if (traceData == null) {
            currentTraceData.remove();
        } else {
            currentTraceData.set(traceData);
        }
    }

    public static TraceData initNewServiceTrace(TraceData traceData, IdGenerator traceIdGenerator, IdGenerator spanIdGenerator) {
        return TraceContext.initServiceTraceData(traceData, traceIdGenerator, spanIdGenerator);
    }

    public static TraceData initServiceTraceData(TraceData traceData, IdGenerator traceIdGenerator, IdGenerator spanIdGenerator) {
        if (traceData.isRoot()) {
            TraceContext.initSpan(traceIdGenerator, spanIdGenerator, traceData, false);
        }
        return traceData;
    }

    public static void reset() {
        TraceData traceData = TraceContext.getCurrentTraceData();
        if (traceData != null) {
            traceData.reset();
        }
    }

    public static TraceContext forClient(IdGenerator idGenerator) {
        return new TraceContext(idGenerator);
    }

    public static TraceContext forClient(IdGenerator idGenerator, Runnable postInit, Runnable preDestroy, Runnable preErrDestroy) {
        return new TraceContext(idGenerator, postInit, preDestroy, preErrDestroy);
    }

    public static TraceContext forService() {
        return new TraceContext(null);
    }

    public static TraceContext forService(Runnable postInit, Runnable preDestroy, Runnable preErrDestroy) {
        return new TraceContext(null, postInit, preDestroy, preErrDestroy);
    }

    private static TraceData createNewTraceData(TraceData oldTraceData) {
        return new TraceData(oldTraceData, true);
    }

    private static TraceData initSpan(IdGenerator traceIdGenerator, IdGenerator spanIdGenerator, TraceData traceData, boolean isClient) {
        String traceId;
        long timestamp = System.currentTimeMillis();
        Span clientSpan = traceData.getClientSpan().getSpan();
        Span serviceSpan = traceData.getServiceSpan().getSpan();
        Span initSpan = isClient ? clientSpan : serviceSpan;
        boolean root = traceData.isRoot();
        String string = traceId = root ? traceIdGenerator.generateId() : serviceSpan.getTraceId();
        if (root) {
            initSpan.setId(spanIdGenerator.generateId());
            initSpan.setParentId(NO_PARENT_ID);
        } else {
            initSpan.setId(spanIdGenerator.generateId("", traceData.getServiceSpan().getCounter().incrementAndGet()));
            initSpan.setParentId(serviceSpan.getId());
            if (!initSpan.hasDeadline()) {
                initSpan.setDeadline(serviceSpan.getDeadline());
            }
        }
        initSpan.setTraceId(traceId);
        TraceContext.initTime(initSpan, timestamp);
        return traceData;
    }

    private static void initTime(Span span, long timestamp) {
        span.setTimestamp(timestamp);
    }

    public void init() {
        TraceData traceData = TraceContext.getCurrentTraceData();
        traceData = this.isClientInit(traceData) ? this.initClientContext(traceData) : this.initServiceContext(traceData);
        TraceContext.setCurrentTraceData(traceData);
        MDCUtils.putSpanData(traceData.getActiveSpan().getSpan());
        this.postInit.run();
    }

    public void destroy() {
        this.destroy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(boolean onError) {
        TraceData traceData = TraceContext.getCurrentTraceData();
        boolean isClient = this.isClientDestroy(traceData);
        this.setDuration(traceData, isClient);
        try {
            if (onError) {
                this.preErrDestroy.run();
            } else {
                this.preDestroy.run();
            }
        }
        finally {
            traceData = isClient ? this.destroyClientContext(traceData) : this.destroyServiceContext(traceData);
            TraceContext.setCurrentTraceData(traceData);
            if (traceData.getServiceSpan().isFilled()) {
                MDCUtils.putSpanData(traceData.getServiceSpan().getSpan());
            } else {
                MDCUtils.removeSpanData();
            }
        }
    }

    public void setDuration() {
        this.setDuration(TraceContext.getCurrentTraceData(), this.isClient);
    }

    private void setDuration(TraceData traceData, boolean isClient) {
        Span span = isClient ? traceData.getClientSpan().getSpan() : traceData.getServiceSpan().getSpan();
        span.setDuration(System.currentTimeMillis() - span.getTimestamp());
    }

    private TraceData initClientContext(TraceData traceData) {
        savedTraceData.set(traceData);
        traceData = TraceContext.createNewTraceData(traceData);
        TraceContext.initSpan(this.traceIdGenerator, this.spanIdGenerator, traceData, true);
        return traceData;
    }

    private TraceData destroyClientContext(TraceData traceData) {
        traceData = savedTraceData.get();
        savedTraceData.remove();
        return traceData;
    }

    private TraceData initServiceContext(TraceData traceData) {
        TraceContext.initTime(traceData.getServiceSpan().getSpan(), System.currentTimeMillis());
        return traceData;
    }

    private TraceData destroyServiceContext(TraceData traceData) {
        TraceContext.reset();
        return traceData;
    }

    private boolean isClientInit(TraceData traceData) {
        return this.isAuto ? this.isClientInitAuto(traceData) : this.isClient;
    }

    private boolean isClientDestroy(TraceData traceData) {
        return this.isAuto ? this.isClientDestroyAuto(traceData) : this.isClient;
    }

    private boolean isClientInitAuto(TraceData traceData) {
        Span serverSpan = traceData.getServiceSpan().getSpan();
        assert (!traceData.getClientSpan().isStarted() || !traceData.getServiceSpan().isStarted());
        assert (!traceData.getClientSpan().isFilled() || !traceData.getServiceSpan().isFilled());
        return !serverSpan.isFilled() || serverSpan.isStarted();
    }

    private boolean isClientDestroyAuto(TraceData traceData) {
        return traceData.getServiceSpan().isStarted() ? traceData.getClientSpan().isStarted() : !traceData.getServiceSpan().isFilled();
    }
}

