/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http;

import dev.vality.woody.api.AbstractServiceBuilder;
import dev.vality.woody.api.event.CompositeServiceEventListener;
import dev.vality.woody.api.event.ServiceEventListener;
import dev.vality.woody.api.flow.error.WErrorDefinition;
import dev.vality.woody.api.flow.error.WErrorMapper;
import dev.vality.woody.api.flow.error.WErrorType;
import dev.vality.woody.api.interceptor.CommonInterceptor;
import dev.vality.woody.api.interceptor.CompositeInterceptor;
import dev.vality.woody.api.interceptor.ContainerCommonInterceptor;
import dev.vality.woody.api.interceptor.ContextInterceptor;
import dev.vality.woody.api.interceptor.ErrorMappingInterceptor;
import dev.vality.woody.api.interceptor.ext.ExtensionBundle;
import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.api.trace.context.TraceContext;
import dev.vality.woody.api.trace.context.metadata.MetadataExtensionKit;
import dev.vality.woody.api.transport.TransportEventInterceptor;
import dev.vality.woody.thrift.impl.http.BuilderUtils;
import dev.vality.woody.thrift.impl.http.error.THErrorMapProcessor;
import dev.vality.woody.thrift.impl.http.event.THSEventLogListener;
import dev.vality.woody.thrift.impl.http.event.THServiceEvent;
import dev.vality.woody.thrift.impl.http.interceptor.THMessageInterceptor;
import dev.vality.woody.thrift.impl.http.interceptor.THTransportInterceptor;
import dev.vality.woody.thrift.impl.http.interceptor.ext.MetadataExtensionBundle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.servlet.Servlet;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet;

public class THServiceBuilder
extends AbstractServiceBuilder<Servlet> {
    private final THSEventLogListener logListener = new THSEventLogListener();
    private List<MetadataExtensionKit> metadataExtensionKits;
    private boolean logEnabled = true;
    private WErrorMapper errorMapper;

    @Override
    public THServiceBuilder withEventListener(ServiceEventListener listener) {
        return (THServiceBuilder)super.withEventListener(listener);
    }

    public THServiceBuilder withMetaExtensions(List<MetadataExtensionKit> extensionKits) {
        this.metadataExtensionKits = extensionKits;
        return this;
    }

    public THServiceBuilder withLogEnabled(boolean enabled) {
        this.logEnabled = enabled;
        return this;
    }

    public THServiceBuilder withErrorMapper(WErrorMapper errorMapper) {
        this.errorMapper = errorMapper;
        return this;
    }

    @Override
    public <T> Servlet build(Class<T> iface, T serviceHandler) {
        if (this.logEnabled) {
            ServiceEventListener listener = this.getEventListener();
            listener = listener == null || listener == DEFAULT_EVENT_LISTENER ? this.logListener : new CompositeServiceEventListener(this.logListener, listener);
            this.withEventListener(listener);
        }
        return (Servlet)super.build(iface, serviceHandler);
    }

    protected BiConsumer<WErrorDefinition, ContextSpan> getErrorDefinitionConsumer() {
        return (eDef, contextSpan) -> {
            if (eDef.getErrorType() != WErrorType.BUSINESS_ERROR) {
                contextSpan.getMetadata().removeValue("md_thrift_http_transport_response_set_flag");
            }
        };
    }

    @Override
    protected Runnable getErrorListener() {
        return this.createEventRunnable(this.getEventListener());
    }

    @Override
    protected Runnable getOnCallStartEventListener() {
        return this.createEventRunnable(this.getEventListener());
    }

    @Override
    protected Runnable getOnCallEndEventListener() {
        return this.createEventRunnable(this.getEventListener());
    }

    @Override
    protected Runnable getOnSendEventListener() {
        return this.createEventRunnable(this.getEventListener());
    }

    @Override
    protected Runnable getOnReceiveEventListener() {
        return this.createEventRunnable(this.getEventListener());
    }

    @Override
    protected <T> Servlet createProviderService(Class<T> serviceInterface, T handler) {
        try {
            THErrorMapProcessor errorMapProcessor = THErrorMapProcessor.getInstance(false, serviceInterface, this.errorMapper);
            TProcessor tProcessor = this.createThriftProcessor(serviceInterface, handler);
            return this.createThriftServlet(tProcessor, this.createInterceptor(errorMapProcessor, true), errorMapProcessor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected TProtocolFactory createTransferProtocolFactory() {
        return new TBinaryProtocol.Factory();
    }

    protected CommonInterceptor createInterceptor(THErrorMapProcessor errorMapProcessor, boolean isTransportLevel) {
        ArrayList<CommonInterceptor> interceptors = new ArrayList<CommonInterceptor>();
        if (!isTransportLevel) {
            interceptors.add(new ContainerCommonInterceptor(new THMessageInterceptor(false, true), new THMessageInterceptor(false, false)));
        }
        List<ExtensionBundle> extensionBundles = Arrays.asList(new MetadataExtensionBundle(this.metadataExtensionKits == null ? Collections.EMPTY_LIST : this.metadataExtensionKits));
        interceptors.add(new ErrorMappingInterceptor(errorMapProcessor, this.getErrorDefinitionConsumer()));
        interceptors.add(new ContainerCommonInterceptor(isTransportLevel ? new THTransportInterceptor(extensionBundles, false, true) : null, new THTransportInterceptor(extensionBundles, false, false)));
        if (isTransportLevel) {
            interceptors.add(new ContextInterceptor(TraceContext.forService(), new TransportEventInterceptor(this.getOnReceiveEventListener(), this.getOnReceiveEventListener(), this.getErrorListener())));
        }
        return new CompositeInterceptor(interceptors.toArray(new CommonInterceptor[interceptors.size()]));
    }

    protected Servlet createThriftServlet(TProcessor tProcessor, CommonInterceptor servletInterceptor, THErrorMapProcessor errorMapProcessor) {
        TProtocolFactory tProtocolFactory = this.createTransferProtocolFactory();
        TProtocolFactory wtProtocolFactory = BuilderUtils.wrapProtocolFactory(tProtocolFactory, this.createInterceptor(errorMapProcessor, false), false);
        return new TServlet(tProcessor, wtProtocolFactory, servletInterceptor);
    }

    protected <T> TProcessor createThriftProcessor(Class<T> serviceInterface, T handler) {
        try {
            Optional<Class> processorClass = Arrays.stream(serviceInterface.getDeclaringClass().getClasses()).filter(cl -> cl.getSimpleName().equals("Processor")).findFirst();
            if (!processorClass.isPresent()) {
                throw new IllegalArgumentException("Service interface doesn't conform to Thrift generated class structure");
            }
            if (!TProcessor.class.isAssignableFrom(processorClass.get())) {
                throw new IllegalArgumentException("Service class doesn't conform to Thrift generated class structure");
            }
            Constructor constructor = processorClass.get().getConstructor(serviceInterface);
            if (constructor == null) {
                throw new IllegalArgumentException("Service class doesn't have required constructor to be created");
            }
            return (TProcessor)constructor.newInstance(handler);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to createCtxBundle provider service", e);
        }
    }

    private Runnable createEventRunnable(ServiceEventListener eventListener) {
        return () -> eventListener.notifyEvent(new THServiceEvent(TraceContext.getCurrentTraceData()));
    }
}

