/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.error;

import dev.vality.woody.api.flow.error.WErrorDefinition;
import dev.vality.woody.api.flow.error.WErrorMapper;
import dev.vality.woody.api.flow.error.WErrorSource;
import dev.vality.woody.api.flow.error.WErrorType;
import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.thrift.impl.http.error.ErrorAnalyzer;
import dev.vality.woody.thrift.impl.http.error.ErrorStackAnalyzer;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.apache.http.NoHttpResponseException;

public class THTransportErrorMapper
implements WErrorMapper {
    private static final ErrorAnalyzer[] analyzers = new ErrorAnalyzer[]{new ErrorAnalyzer(Pattern.compile(SocketTimeoutException.class.getName()), THTransportErrorMapper::getUndefinedResult), new ErrorAnalyzer(Pattern.compile(Pattern.quote(NoHttpResponseException.class.getName())), THTransportErrorMapper::genUnavailableResult), new ErrorAnalyzer(Pattern.compile(Pattern.quote(UnknownHostException.class.getName())), THTransportErrorMapper::genUnavailableResult), new ErrorAnalyzer(Pattern.compile(Pattern.quote(ConnectException.class.getName())), THTransportErrorMapper::genUnavailableResult), new ErrorAnalyzer(Pattern.compile("java\\.net\\.Socket\\..*"), THTransportErrorMapper::genUnavailableResult), new ErrorAnalyzer(Pattern.compile("java\\.net\\..*"), THTransportErrorMapper::getUndefinedResult)};

    private static WErrorDefinition genUnavailableResult(Throwable t, ContextSpan c) {
        WErrorDefinition def = new WErrorDefinition(WErrorSource.EXTERNAL);
        def.setErrorSource(WErrorSource.INTERNAL);
        def.setErrorType(WErrorType.UNAVAILABLE_RESULT);
        def.setErrorReason(t.toString());
        def.setErrorMessage(t.getMessage());
        return def;
    }

    private static WErrorDefinition getUndefinedResult(Throwable t, ContextSpan c) {
        WErrorDefinition def = new WErrorDefinition(WErrorSource.EXTERNAL);
        def.setErrorSource(WErrorSource.INTERNAL);
        def.setErrorType(WErrorType.UNDEFINED_RESULT);
        def.setErrorReason(t.toString());
        def.setErrorMessage(t.getMessage());
        return def;
    }

    @Override
    public WErrorDefinition mapToDef(Throwable t, ContextSpan contextSpan) {
        return ErrorStackAnalyzer.analyzeStack(analyzers, t, contextSpan);
    }

    @Override
    public Exception mapToError(WErrorDefinition errorDefinition, ContextSpan contextSpan) {
        return null;
    }
}

