/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.event;

import dev.vality.woody.api.event.ServiceEventListener;
import dev.vality.woody.thrift.impl.http.event.THServiceEvent;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEventLogListener
implements ServiceEventListener<THServiceEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void notifyEvent(THServiceEvent event) {
        try {
            switch (event.getEventType()) {
                case CALL_HANDLER: {
                    this.log.info("SERVER Event: {}, [{}, Type: {}], Time: {}", new Object[]{event.getEventType(), event.getCallName(), event.getCallType(), event.getTimeStamp()});
                    break;
                }
                case HANDLER_RESULT: {
                    this.log.info("SERVER Event: {}, Status: {}, Time: {}", new Object[]{event.getEventType(), event.isSuccessfulCall() ? "ok" : "error", event.getTimeStamp()});
                    break;
                }
                case SERVICE_RECEIVE: {
                    this.log.info("SERVER Event: {}, Status: {}, Url: {}, Time: {}", new Object[]{event.getEventType(), event.isSuccessfulCall() ? "ok" : "error", event.getEndpoint().getStringValue(), event.getTimeStamp()});
                    break;
                }
                case SERVICE_RESULT: {
                    this.log.info("SERVER Event: {}, Status: {}, Time: {}, Duration: {}", new Object[]{event.getEventType(), event.isSuccessfulCall() ? "ok" : "error", event.getTimeStamp(), event.getDuration()});
                    break;
                }
                case ERROR: {
                    this.log.info("SERVER Event: {}, ErrType: {}, TErrType: {}, ErrName: {},  Time: {}", new Object[]{event.getEventType(), event.getErrorDefinition(), event.getThriftErrorType(), Optional.ofNullable(event.getErrorDefinition()).map(ed -> ed.getErrorName()).orElse(""), event.getTimeStamp()});
                    break;
                }
                default: {
                    this.log.info("SERVER Unknown error: {}", (Object)event);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed to process event", e);
        }
    }
}

