/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.interceptor.ext;

import dev.vality.woody.api.flow.error.WErrorDefinition;
import dev.vality.woody.api.flow.error.WErrorType;
import dev.vality.woody.api.interceptor.ext.ExtensionBundle;
import dev.vality.woody.api.trace.ClientSpan;
import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.api.trace.Metadata;
import dev.vality.woody.api.trace.ServiceSpan;
import dev.vality.woody.api.trace.Span;
import dev.vality.woody.thrift.impl.http.THResponseInfo;
import dev.vality.woody.thrift.impl.http.error.THProviderErrorMapper;
import dev.vality.woody.thrift.impl.http.interceptor.THRequestInterceptionException;
import dev.vality.woody.thrift.impl.http.transport.THttpHeader;
import dev.vality.woody.thrift.impl.http.transport.TTransportErrorType;
import dev.vality.woody.thrift.impl.http.transport.UrlStringEndpoint;
import java.net.URL;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportExtensionBundles {
    public static final ExtensionBundle TRANSPORT_CONFIG_BUNDLE = ExtensionBundle.createServiceExtBundle(ExtensionBundle.ContextBundle.createCtxBundle(reqSCtx -> {
        String reqMethod = reqSCtx.getProviderRequest().getMethod();
        if (!"POST".equals(reqMethod)) {
            throw new THRequestInterceptionException(TTransportErrorType.BAD_REQUEST_TYPE, reqMethod);
        }
        String cType = reqSCtx.getProviderRequest().getContentType();
        if (!"application/x-thrift".equalsIgnoreCase(cType)) {
            throw new THRequestInterceptionException(TTransportErrorType.BAD_CONTENT_TYPE, cType);
        }
    }, respSCtx -> {}));
    public static final ExtensionBundle DEADLINE_BUNDLE = ExtensionBundle.createExtBundle(ExtensionBundle.ContextBundle.createCtxBundle(reqCCtx -> {
        ClientSpan clientSpan = reqCCtx.getTraceData().getClientSpan();
        Instant deadline = ContextUtils.getDeadline(clientSpan);
        if (deadline != null) {
            reqCCtx.setRequestHeader(THttpHeader.DEADLINE.getKey(), deadline.toString());
        }
    }, respCCtx -> {}), ExtensionBundle.ContextBundle.createCtxBundle(reqSCtx -> {
        HttpServletRequest request = reqSCtx.getProviderRequest();
        ServiceSpan serviceSpan = reqSCtx.getTraceData().getServiceSpan();
        String deadlineHeader = THttpHeader.DEADLINE.getKey();
        String deadlineHeaderValue = request.getHeader(deadlineHeader);
        if (deadlineHeaderValue != null) {
            try {
                Instant deadline = Instant.parse(deadlineHeaderValue);
                ContextUtils.setDeadline(serviceSpan, deadline);
            }
            catch (DateTimeParseException ex) {
                throw new THRequestInterceptionException(TTransportErrorType.BAD_HEADER, deadlineHeader, ex);
            }
        }
    }, respSCtx -> {
        Instant deadline = ContextUtils.getDeadline(respSCtx.getTraceData().getServiceSpan());
        if (deadline != null) {
            respSCtx.setResponseHeader(THttpHeader.DEADLINE.getKey(), deadline.toString());
        }
    }));
    public static final ExtensionBundle CALL_ENDPOINT_BUNDLE = ExtensionBundle.createExtBundle(ExtensionBundle.ContextBundle.createCtxBundle(reqCCtx -> {
        ClientSpan contextSpan = reqCCtx.getTraceData().getClientSpan();
        URL url = reqCCtx.getRequestCallEndpoint();
        contextSpan.getMetadata().putValue("md_call_endpoint", new UrlStringEndpoint(url == null ? null : url.toString()));
    }, respCCtx -> {}), ExtensionBundle.ContextBundle.createCtxBundle(reqSCtx -> {
        HttpServletRequest request = reqSCtx.getProviderRequest();
        String queryString = request.getQueryString();
        StringBuffer sb = request.getRequestURL();
        if (queryString != null) {
            sb.append('?').append(request.getQueryString());
        }
        reqSCtx.getTraceData().getServiceSpan().getMetadata().putValue("md_call_endpoint", new UrlStringEndpoint(sb.toString()));
    }, reqSCtx -> {}));
    public static final ExtensionBundle TRANSPORT_INJECTION_BUNDLE = ExtensionBundle.createExtBundle(ExtensionBundle.ContextBundle.createCtxBundle(reqCCtx -> reqCCtx.getTraceData().getClientSpan().getMetadata().putValue("md_thrift_http_transport_request", reqCCtx.getProviderContext()), respCCtx -> respCCtx.getTraceData().getClientSpan().getMetadata().putValue("md_thrift_http_transport_response", respCCtx.getProviderContext())), ExtensionBundle.ContextBundle.createCtxBundle(reqSCtx -> {
        HttpServletResponse response = ContextUtils.getContextValue(HttpServletResponse.class, reqSCtx.getContextParameters(), 0);
        ServiceSpan serviceSpan = reqSCtx.getTraceData().getServiceSpan();
        serviceSpan.getMetadata().putValue("md_thrift_http_transport_request", reqSCtx.getProviderRequest());
        serviceSpan.getMetadata().putValue("md_thrift_http_transport_response", response);
    }, respSCtx -> {}));
    private static final Logger log = LoggerFactory.getLogger(TransportExtensionBundles.class);
    public static final ExtensionBundle RPC_ID_BUNDLE = ExtensionBundle.createExtBundle(ExtensionBundle.ContextBundle.createCtxBundle(reqCCtx -> {
        Span span = reqCCtx.getTraceData().getClientSpan().getSpan();
        reqCCtx.setRequestHeader(THttpHeader.TRACE_ID.getKey(), span.getTraceId());
        reqCCtx.setRequestHeader(THttpHeader.SPAN_ID.getKey(), span.getId());
        reqCCtx.setRequestHeader(THttpHeader.PARENT_ID.getKey(), span.getParentId());
    }, respCCtx -> {}), ExtensionBundle.ContextBundle.createCtxBundle(reqSCtx -> {
        HttpServletRequest request = reqSCtx.getProviderRequest();
        Span span = reqSCtx.getTraceData().getServiceSpan().getSpan();
        Map.Entry[] entryArray = new Map.Entry[3];
        entryArray[0] = new AbstractMap.SimpleEntry<THttpHeader, Consumer<String>>(THttpHeader.TRACE_ID, span::setTraceId);
        entryArray[1] = new AbstractMap.SimpleEntry<THttpHeader, Consumer<String>>(THttpHeader.PARENT_ID, span::setParentId);
        entryArray[2] = new AbstractMap.SimpleEntry<THttpHeader, Consumer<String>>(THttpHeader.SPAN_ID, span::setId);
        List<Map.Entry<THttpHeader, Consumer<String>>> headerConsumers = Arrays.asList(entryArray);
        TransportExtensionBundles.validateAndProcessTraceHeaders(request, THttpHeader::getKey, headerConsumers);
    }, respSCtx -> {
        Span span = respSCtx.getTraceData().getServiceSpan().getSpan();
        respSCtx.setResponseHeader(THttpHeader.TRACE_ID.getKey(), span.getTraceId());
        respSCtx.setResponseHeader(THttpHeader.PARENT_ID.getKey(), span.getParentId());
        respSCtx.setResponseHeader(THttpHeader.SPAN_ID.getKey(), span.getId());
    }));
    public static final ExtensionBundle TRANSPORT_STATE_MAPPING_BUNDLE = ExtensionBundle.createExtBundle(ExtensionBundle.ContextBundle.createCtxBundle(reqCCtx -> {}, respCCtx -> {
        int status = respCCtx.getResponseStatus();
        Metadata metadata = respCCtx.getTraceData().getClientSpan().getMetadata();
        metadata.putValue("md_thrift_http_response_status", status);
        metadata.putValue("md_thrift_http_response_message", respCCtx.getResponseMessage());
        String errorClassHeaderKey = THttpHeader.ERROR_CLASS.getKey();
        String errorReasonHeaderKey = THttpHeader.ERROR_REASON.getKey();
        THResponseInfo thResponseInfo = new THResponseInfo(status, respCCtx.getResponseHeader(errorClassHeaderKey), respCCtx.getResponseHeader(errorReasonHeaderKey), respCCtx.getResponseMessage());
        WErrorDefinition errorDefinition = THProviderErrorMapper.createErrorDefinition(thResponseInfo, () -> {
            throw new THRequestInterceptionException(TTransportErrorType.BAD_HEADER, errorClassHeaderKey);
        });
        metadata.putValue("md_error_def", errorDefinition);
        if (errorDefinition != null && errorDefinition.getErrorType() != WErrorType.BUSINESS_ERROR) {
            metadata.putValue("response_skip_reading", true);
        }
    }), ExtensionBundle.ContextBundle.createCtxBundle(reqSCtx -> {}, respSCtx -> {
        ServiceSpan serviceSpan = respSCtx.getTraceData().getServiceSpan();
        if (serviceSpan.getMetadata().containsKey("md_thrift_http_transport_response_set_flag")) {
            return;
        }
        TransportExtensionBundles.logIfError(serviceSpan);
        HttpServletResponse response = respSCtx.getProviderResponse();
        if (response.isCommitted()) {
            log.error("Can't perform response mapping: Transport response is already committed");
        } else {
            THResponseInfo responseInfo = THProviderErrorMapper.getResponseInfo(serviceSpan);
            response.setStatus(responseInfo.getStatus());
            Optional.ofNullable(responseInfo.getErrClass()).ifPresent(val -> response.setHeader(THttpHeader.ERROR_CLASS.getKey(), val));
            Optional.ofNullable(responseInfo.getErrReason()).ifPresent(val -> response.setHeader(THttpHeader.ERROR_REASON.getKey(), val));
            serviceSpan.getMetadata().putValue("md_thrift_http_transport_response_set_flag", true);
        }
    }));
    private static final List<ExtensionBundle> clientList = Collections.unmodifiableList(Arrays.asList(RPC_ID_BUNDLE, CALL_ENDPOINT_BUNDLE, TRANSPORT_STATE_MAPPING_BUNDLE, TRANSPORT_INJECTION_BUNDLE, DEADLINE_BUNDLE));
    private static final List<ExtensionBundle> serviceList = Collections.unmodifiableList(Arrays.asList(TRANSPORT_CONFIG_BUNDLE, RPC_ID_BUNDLE, CALL_ENDPOINT_BUNDLE, TRANSPORT_STATE_MAPPING_BUNDLE, TRANSPORT_INJECTION_BUNDLE, DEADLINE_BUNDLE));

    public static List<ExtensionBundle> getClientExtensions() {
        return clientList;
    }

    public static List<ExtensionBundle> getServiceExtensions() {
        return serviceList;
    }

    public static List<ExtensionBundle> getExtensions(boolean isClient) {
        return isClient ? TransportExtensionBundles.getClientExtensions() : TransportExtensionBundles.getServiceExtensions();
    }

    private static void logIfError(ContextSpan contextSpan) {
        Throwable t = ContextUtils.getCallError(contextSpan);
        if (t != null) {
            log.debug("Response has error:", t);
        }
    }

    private static void validateAndProcessTraceHeaders(HttpServletRequest request, Function<THttpHeader, String> getHeaderKeyFunction, List<Map.Entry<THttpHeader, Consumer<String>>> headerConsumers) {
        List missingHeaders;
        if (log.isDebugEnabled()) {
            TransportExtensionBundles.printHeader(request);
        }
        if (!(missingHeaders = headerConsumers.stream().filter(entry -> {
            String id = Optional.ofNullable(request.getHeader((String)getHeaderKeyFunction.apply((THttpHeader)((Object)((Object)entry.getKey()))))).orElse("");
            ((Consumer)entry.getValue()).accept(id);
            return id.isEmpty();
        }).map(entry -> (String)getHeaderKeyFunction.apply((THttpHeader)((Object)((Object)entry.getKey())))).collect(Collectors.toList())).isEmpty()) {
            throw new THRequestInterceptionException(TTransportErrorType.BAD_TRACE_HEADER, String.join((CharSequence)", ", missingHeaders));
        }
    }

    private static void printHeader(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        Map headersMap = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), headerName -> Collections.list(request.getHeaders(headerName))));
        log.debug("Request headers: {}", (Object)headersMap);
    }
}

