/*
 * Decompiled with CFR 0.152.
 */
package com.rbkmoney.swag.dark_api.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rbkmoney.swag.dark_api.model.FileData;
import com.rbkmoney.swag.dark_api.model.FileDownload;
import com.rbkmoney.swag.dark_api.model.FileUploadData;
import com.rbkmoney.swag.dark_api.model.FileUploadRequest;
import com.rbkmoney.swag.dark_api.model.GeneralError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="files", description="the files API")
public interface FilesApi {
    public static final Logger log = LoggerFactory.getLogger(FilesApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="", nickname="downloadFile", notes="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u0434\u043b\u044f \u0441\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430", response=FileDownload.class, authorizations={@Authorization(value="bearer")}, tags={"Files"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430", response=FileDownload.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/files/{fileID}/download"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<FileDownload> downloadFile(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0444\u0430\u0439\u043b\u0430", required=true) @PathVariable(value="fileID") String fileID) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((FileDownload)this.getObjectMapper().get().readValue("{  \"url\" : \"url\"}", FileDownload.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default FilesApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getFileInfo", notes="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0444\u0430\u0439\u043b\u0435", response=FileData.class, authorizations={@Authorization(value="bearer")}, tags={"Files"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0414\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u0430", response=FileData.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/files/{fileID}/info"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<FileData> getFileInfo(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0444\u0430\u0439\u043b\u0430", required=true) @PathVariable(value="fileID") String fileID) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((FileData)this.getObjectMapper().get().readValue("{  \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",  \"fileName\" : \"fileName\",  \"metadata\" : \"{}\",  \"fileId\" : \"fileId\"}", FileData.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default FilesApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="uploadFile", notes="\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b \u0438 \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440", response=FileUploadData.class, authorizations={@Authorization(value="bearer")}, tags={"Files"})
    @ApiResponses(value={@ApiResponse(code=201, message="\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440", response=FileUploadData.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438")})
    @RequestMapping(value={"/files/upload"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.POST})
    default public ResponseEntity<FileUploadData> uploadFile(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @ApiParam(value="") @Valid @RequestBody FileUploadRequest uploadFileRequest) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((FileUploadData)this.getObjectMapper().get().readValue("{  \"url\" : \"url\",  \"fileId\" : \"fileId\"}", FileUploadData.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default FilesApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

