/*
 * Decompiled with CFR 0.152.
 */
package com.rbkmoney.swag.dark_api.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rbkmoney.swag.dark_api.model.GeneralError;
import com.rbkmoney.swag.dark_api.model.InlineResponse200;
import com.rbkmoney.swag.dark_api.model.InlineResponse400;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="search", description="the search API")
public interface SearchApi {
    public static final Logger log = LoggerFactory.getLogger(SearchApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="", nickname="searchPayments", notes="\u041f\u043e\u0438\u0441\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", response=InlineResponse200.class, authorizations={@Authorization(value="bearer")}, tags={"Search"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438", response=InlineResponse200.class), @ApiResponse(code=400, message="\u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u043f\u043e\u0438\u0441\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", response=InlineResponse400.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/search/payments/{shopID}"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse200> searchPayments(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430", required=true) @PathVariable(value="shopID") String shopID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @NotNull @Min(value=1L) @Max(value=1000L) @ApiParam(value="\u041b\u0438\u043c\u0438\u0442 \u0432\u044b\u0431\u043e\u0440\u043a\u0438", required=true) @Valid @RequestParam(value="limit", required=true) Integer limit, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430", allowableValues="pending, processed, captured, cancelled, refunded, failed") @Valid @RequestParam(value="paymentStatus", required=false) String paymentStatus, @ApiParam(value="Flow \u043f\u043b\u0430\u0442\u0435\u0436\u0430", allowableValues="instant, hold") @Valid @RequestParam(value="paymentFlow", required=false) String paymentFlow, @ApiParam(value="\u041c\u0435\u0442\u043e\u0434 \u043e\u043f\u043b\u0430\u0442\u044b", allowableValues="bankCard, paymentTerminal") @Valid @RequestParam(value="paymentMethod", required=false) String paymentMethod, @ApiParam(value="\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0433\u043e \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430", allowableValues="euroset") @Valid @RequestParam(value="paymentTerminalProvider", required=false) String paymentTerminalProvider, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0438\u043d\u0432\u043e\u0439\u0441\u0430") @Valid @RequestParam(value="invoiceID", required=false) String invoiceID, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0430") @Valid @RequestParam(value="paymentID", required=false) String paymentID, @Size(max=100) @ApiParam(value="Email, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u0438 \u043e\u043f\u043b\u0430\u0442\u0435") @Valid @RequestParam(value="payerEmail", required=false) String payerEmail, @Size(max=45) @ApiParam(value="IP-\u0430\u0434\u0440\u0435\u0441 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430") @Valid @RequestParam(value="payerIP", required=false) String payerIP, @Size(max=1000) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043e\u0442\u043f\u0435\u0447\u0430\u0442\u043e\u043a user agent'\u0430 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430") @Valid @RequestParam(value="payerFingerprint", required=false) String payerFingerprint, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430") @Valid @RequestParam(value="customerID", required=false) String customerID, @Pattern(regexp="^\\d{6,8}$") @ApiParam(value="BIN \u0431\u0430\u043d\u043a\u0430-\u044d\u043c\u0438\u0442\u0435\u043d\u0442\u0430 \u043a\u0430\u0440\u0442\u044b") @Valid @RequestParam(value="bin", required=false) String bin, @Pattern(regexp="^\\d{2,4}$") @ApiParam(value="\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0446\u0438\u0444\u0440\u044b \u043d\u043e\u043c\u0435\u0440\u0430 \u043a\u0430\u0440\u0442\u044b") @Valid @RequestParam(value="lastDigits", required=false) String lastDigits, @ApiParam(value="\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0445 \u0442\u043e\u043a\u0435\u043d\u043e\u0432", allowableValues="applepay, googlepay, samsungpay") @Valid @RequestParam(value="bankCardTokenProvider", required=false) String bankCardTokenProvider, @ApiParam(value="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430", allowableValues="visa, mastercard, visaelectron, maestro, forbrugsforeningen, dankort, amex, dinersclub, discover, unionpay, jcb, nspkmir") @Valid @RequestParam(value="bankCardPaymentSystem", required=false) String bankCardPaymentSystem, @Min(value=1L) @ApiParam(value="\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430") @Valid @RequestParam(value="paymentAmount", required=false) Long paymentAmount, @ApiParam(value="\u0422\u043e\u043a\u0435\u043d, \u0441\u0438\u0433\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e\u0449\u0438\u0439 \u043e \u0442\u043e\u043c, \u0447\u0442\u043e \u0432 \u043e\u0442\u0432\u0435\u0442\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0430\u0441\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0445. \u0414\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u043d\u0443\u0436\u043d\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0438\u0441\u0443, \u0443\u043a\u0430\u0437\u0430\u0432 \u0442\u043e\u0442-\u0436\u0435 \u043d\u0430\u0431\u043e\u0440 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b\u0439 \u0442\u043e\u043a\u0435\u043d. \u0415\u0441\u043b\u0438 \u0442\u043e\u043a\u0435\u043d\u0430 \u043d\u0435\u0442, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0447\u0430\u0441\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0445. ") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse200)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ],  \"continuationToken\" : \"continuationToken\"}", InlineResponse200.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SearchApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="searchRefunds", notes="\u041f\u043e\u0438\u0441\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u0432", response=InlineResponse200.class, authorizations={@Authorization(value="bearer")}, tags={"Search"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u044b", response=InlineResponse200.class), @ApiResponse(code=400, message="\u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u043f\u043e\u0438\u0441\u043a\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u0432", response=InlineResponse400.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/search/refunds/{shopID}"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse200> searchRefunds(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430", required=true) @PathVariable(value="shopID") String shopID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @NotNull @Min(value=1L) @Max(value=1000L) @ApiParam(value="\u041b\u0438\u043c\u0438\u0442 \u0432\u044b\u0431\u043e\u0440\u043a\u0438", required=true) @Valid @RequestParam(value="limit", required=true) Integer limit, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0438\u043d\u0432\u043e\u0439\u0441\u0430") @Valid @RequestParam(value="invoiceID", required=false) String invoiceID, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0430") @Valid @RequestParam(value="paymentID", required=false) String paymentID, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430") @Valid @RequestParam(value="refundID", required=false) String refundID, @ApiParam(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430", allowableValues="pending, succeeded, failed") @Valid @RequestParam(value="refundStatus", required=false) String refundStatus, @ApiParam(value="\u0422\u043e\u043a\u0435\u043d, \u0441\u0438\u0433\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e\u0449\u0438\u0439 \u043e \u0442\u043e\u043c, \u0447\u0442\u043e \u0432 \u043e\u0442\u0432\u0435\u0442\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0430\u0441\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0445. \u0414\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u043d\u0443\u0436\u043d\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0438\u0441\u0443, \u0443\u043a\u0430\u0437\u0430\u0432 \u0442\u043e\u0442-\u0436\u0435 \u043d\u0430\u0431\u043e\u0440 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b\u0439 \u0442\u043e\u043a\u0435\u043d. \u0415\u0441\u043b\u0438 \u0442\u043e\u043a\u0435\u043d\u0430 \u043d\u0435\u0442, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0447\u0430\u0441\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0445. ") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse200)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ],  \"continuationToken\" : \"continuationToken\"}", InlineResponse200.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SearchApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

