/*
 * Decompiled with CFR 0.152.
 */
package com.rbkmoney.swag.dark_api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.rbkmoney.swag.dark_api.model.CardData;
import com.rbkmoney.swag.dark_api.model.ClientInfo;
import com.rbkmoney.swag.dark_api.model.InvoiceCart;
import com.rbkmoney.swag.dark_api.model.PaymentFlow;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
public class PaymentParams {
    @JsonProperty(value="externalID")
    private String externalID = null;
    @JsonProperty(value="shopID")
    private String shopID = null;
    @JsonProperty(value="dueDate")
    private OffsetDateTime dueDate = null;
    @JsonProperty(value="amount")
    private Long amount = null;
    @JsonProperty(value="flow")
    private PaymentFlow flow = null;
    @JsonProperty(value="cardData")
    private CardData cardData = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="product")
    private String product = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="cart")
    private InvoiceCart cart = null;
    @JsonProperty(value="metadata")
    private Object metadata = null;
    @JsonProperty(value="clientInfo")
    private ClientInfo clientInfo = null;

    public PaymentParams externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @ApiModelProperty(value="")
    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public PaymentParams shopID(String shopID) {
        this.shopID = shopID;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430")
    @NotNull
    @Size(min=1, max=40)
    public String getShopID() {
        return this.shopID;
    }

    public void setShopID(String shopID) {
        this.shopID = shopID;
    }

    public PaymentParams dueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0438\u043d\u0432\u043e\u0439\u0441\u0430, \u043f\u043e\u0441\u043b\u0435 \u043d\u0430\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0435\u0433\u043e \u0443\u0436\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0431\u0443\u0434\u0435\u0442 \u043e\u043f\u043b\u0430\u0442\u0438\u0442\u044c ")
    @NotNull
    @Valid
    public OffsetDateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public PaymentParams amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433, \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \u0432 \u043a\u043e\u043f\u0435\u0439\u043a\u0430\u0445 \u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0435\u0439 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0432\u0430\u043b\u044e\u0442\u044b.  \u0415\u0441\u043b\u0438 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430, \u0442\u043e \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c\u044e \u0438\u043d\u0432\u043e\u0439\u0441\u0430 \u0431\u0443\u0434\u0435\u0442 \u0441\u0447\u0438\u0442\u0430\u0442\u044c\u0441\u044f \u0441\u0443\u043c\u043c\u0430\u0440\u043d\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043e\u0437\u0438\u0446\u0438\u0439 \u0432 \u043a\u043e\u0440\u0437\u0438\u043d\u0435. ")
    @Min(value=1L)
    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public PaymentParams flow(PaymentFlow flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public PaymentFlow getFlow() {
        return this.flow;
    }

    public void setFlow(PaymentFlow flow) {
        this.flow = flow;
    }

    public PaymentParams cardData(CardData cardData) {
        this.cardData = cardData;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public CardData getCardData() {
        return this.cardData;
    }

    public void setCardData(CardData cardData) {
        this.cardData = cardData;
    }

    public PaymentParams currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentParams product(String product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(required=true, value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433")
    @NotNull
    @Size(max=100)
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public PaymentParams description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433")
    @Size(max=1000)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentParams cart(InvoiceCart cart) {
        this.cart = cart;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public InvoiceCart getCart() {
        return this.cart;
    }

    public void setCart(InvoiceCart cart) {
        this.cart = cart;
    }

    public PaymentParams metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(required=true, value="\u041c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0432\u044f\u0437\u0430\u0442\u044c \u0441 \u0438\u043d\u0432\u043e\u0439\u0441\u043e\u043c")
    @NotNull
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public PaymentParams clientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentParams paymentParams = (PaymentParams)o;
        return Objects.equals(this.externalID, paymentParams.externalID) && Objects.equals(this.shopID, paymentParams.shopID) && Objects.equals(this.dueDate, paymentParams.dueDate) && Objects.equals(this.amount, paymentParams.amount) && Objects.equals(this.flow, paymentParams.flow) && Objects.equals(this.cardData, paymentParams.cardData) && Objects.equals(this.currency, paymentParams.currency) && Objects.equals(this.product, paymentParams.product) && Objects.equals(this.description, paymentParams.description) && Objects.equals(this.cart, paymentParams.cart) && Objects.equals(this.metadata, paymentParams.metadata) && Objects.equals(this.clientInfo, paymentParams.clientInfo);
    }

    public int hashCode() {
        return Objects.hash(this.externalID, this.shopID, this.dueDate, this.amount, this.flow, this.cardData, this.currency, this.product, this.description, this.cart, this.metadata, this.clientInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentParams {\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("    shopID: ").append(this.toIndentedString(this.shopID)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    cardData: ").append(this.toIndentedString(this.cardData)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    cart: ").append(this.toIndentedString(this.cart)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    clientInfo: ").append(this.toIndentedString(this.clientInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

