/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.datasource.hikaricp.module;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import dev.voidframework.datasource.DataSourceManager;
import dev.voidframework.exception.DataSourceException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

@Singleton
public class HikariCpDataSourceManagerProvider
implements Provider<DataSourceManager> {
    private final Config configuration;
    private DataSourceManager dataSourceManager;

    @Inject
    private HikariCpDataSourceManagerProvider(Config configuration) {
        this.configuration = configuration;
    }

    public DataSourceManager get() {
        if (this.dataSourceManager != null) {
            return this.dataSourceManager;
        }
        HashMap<String, BiConsumer<HikariConfig, Config>> optionalHikariConfigToApplyMap = new HashMap<String, BiConsumer<HikariConfig, Config>>();
        optionalHikariConfigToApplyMap.put("cachePrepStmts", (hikariCfg, appCfg) -> hikariCfg.addDataSourceProperty("cachePrepStmts", (Object)appCfg.getString("cachePrepStmts")));
        optionalHikariConfigToApplyMap.put("prepStmtCacheSize", (hikariCfg, appCfg) -> hikariCfg.addDataSourceProperty("prepStmtCacheSize", (Object)appCfg.getString("prepStmtCacheSize")));
        optionalHikariConfigToApplyMap.put("prepStmtCacheSqlLimit", (hikariCfg, appCfg) -> hikariCfg.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)appCfg.getString("prepStmtCacheSqlLimit")));
        optionalHikariConfigToApplyMap.put("connectionTimeout", (hikariCfg, appCfg) -> hikariCfg.setConnectionTimeout((long)appCfg.getInt("connectionTimeout")));
        optionalHikariConfigToApplyMap.put("idleTimeout", (hikariCfg, appCfg) -> hikariCfg.setIdleTimeout((long)appCfg.getInt("idleTimeout")));
        optionalHikariConfigToApplyMap.put("keepaliveTime", (hikariCfg, appCfg) -> hikariCfg.setKeepaliveTime((long)appCfg.getInt("keepaliveTime")));
        optionalHikariConfigToApplyMap.put("connectionInitSql", (hikariCfg, appCfg) -> hikariCfg.setConnectionInitSql(appCfg.getString("connectionInitSql")));
        optionalHikariConfigToApplyMap.put("connectionTestQuery", (hikariCfg, appCfg) -> hikariCfg.setConnectionTestQuery(appCfg.getString("connectionTestQuery")));
        optionalHikariConfigToApplyMap.put("autoCommit", (hikariCfg, appCfg) -> hikariCfg.setAutoCommit(appCfg.getBoolean("autoCommit")));
        optionalHikariConfigToApplyMap.put("minimumIdle", (hikariCfg, appCfg) -> hikariCfg.setMinimumIdle(appCfg.getInt("minimumIdle")));
        optionalHikariConfigToApplyMap.put("maximumPoolSize", (hikariCfg, appCfg) -> hikariCfg.setMaximumPoolSize(appCfg.getInt("maximumPoolSize")));
        optionalHikariConfigToApplyMap.put("maxConnectionAge", (hikariCfg, appCfg) -> hikariCfg.setMaxLifetime((long)appCfg.getInt("maxConnectionAge")));
        HashMap<String, HikariDataSource> hikariDataSourcePerNameMap = new HashMap<String, HikariDataSource>();
        Set dbConfigurationNameSet = this.configuration.getConfig("voidframework.datasource").entrySet().stream().map(Map.Entry::getKey).map(key -> {
            if (key.contains(".")) {
                return key.substring(0, key.indexOf("."));
            }
            return key;
        }).collect(Collectors.toSet());
        if (dbConfigurationNameSet.isEmpty()) {
            throw new DataSourceException.NotConfigured();
        }
        for (String dbConfigurationName : dbConfigurationNameSet) {
            Config dbConfiguration = this.configuration.getConfig("voidframework.datasource." + dbConfigurationName);
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setPoolName(dbConfigurationName);
            hikariConfig.setJdbcUrl(dbConfiguration.getString("url"));
            hikariConfig.setUsername(dbConfiguration.getString("username"));
            hikariConfig.setPassword(dbConfiguration.getString("password"));
            try {
                hikariConfig.setDriverClassName(dbConfiguration.getString("driver"));
            }
            catch (RuntimeException exception) {
                throw new DataSourceException.DriverLoadFailure(dbConfiguration.getString("driver"), (Throwable)exception);
            }
            for (Map.Entry entrySet : optionalHikariConfigToApplyMap.entrySet()) {
                if (!dbConfiguration.hasPath((String)entrySet.getKey())) continue;
                ((BiConsumer)entrySet.getValue()).accept(hikariConfig, dbConfiguration);
            }
            hikariDataSourcePerNameMap.put(dbConfigurationName, new HikariDataSource(hikariConfig));
        }
        this.dataSourceManager = new DataSourceManager(hikariDataSourcePerNameMap);
        return this.dataSourceManager;
    }
}

