/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.datasource.hikaricp.module;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import dev.voidframework.datasource.AbstractDataSourceProvider;
import dev.voidframework.datasource.DataSourceManager;
import dev.voidframework.datasource.exception.DataSourceException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

@Singleton
public class HikariCpDataSourceManagerProvider
extends AbstractDataSourceProvider {
    private static final String HIKARICP_PROPERTIES_CACHE_PREPARED_STATEMENTS = "cachePrepStmts";
    private static final String HIKARICP_PROPERTIES_PREPARED_STATEMENT_CACHE_SIZE = "prepStmtCacheSize";
    private static final String HIKARICP_PROPERTIES_PREPARED_STATEMENT_CACHE_SQL_LIMIT = "prepStmtCacheSqlLimit";
    private static final String CONFIGURATION_KEY_DRIVER_CLASS = "driver";
    private static final String CONFIGURATION_KEY_URL = "url";
    private static final String CONFIGURATION_KEY_USERNAME = "username";
    private static final String CONFIGURATION_KEY_PASSWORD = "password";
    private static final String CONFIGURATION_KEY_CACHE_PREPARED_STATEMENTS = "cachePrepStmts";
    private static final String CONFIGURATION_KEY_PREPARED_STATEMENT_CACHE_SIZE = "prepStmtCacheSize";
    private static final String CONFIGURATION_KEY_PREPARED_STATEMENT_CACHE_SQL_LIMIT = "prepStmtCacheSqlLimit";
    private static final String CONFIGURATION_KEY_CONNECTION_TIMEOUT = "connectionTimeout";
    private static final String CONFIGURATION_KEY_IDLE_TIMEOUT = "idleTimeout";
    private static final String CONFIGURATION_KEY_KEEPALIVE_TIME = "keepaliveTime";
    private static final String CONFIGURATION_KEY_CONNECTION_INITIALISATION_SQL_QUERY = "connectionInitSql";
    private static final String CONFIGURATION_KEY_CONNECTION_TEST_SQL_QUERY = "connectionTestQuery";
    private static final String CONFIGURATION_KEY_AUTO_COMMIT = "autoCommit";
    private static final String CONFIGURATION_KEY_CONNECTION_POOL_MINIMUM_IDLE = "minimumIdle";
    private static final String CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_SIZE = "maximumPoolSize";
    private static final String CONFIGURATION_KEY_MAXIMUM_CONNECTION_AGE = "maxConnectionAge";
    private final Config configuration;
    private DataSourceManager dataSourceManager;

    @Inject
    private HikariCpDataSourceManagerProvider(Config configuration) {
        this.configuration = configuration;
    }

    public DataSourceManager get() {
        if (this.dataSourceManager != null) {
            return this.dataSourceManager;
        }
        HashMap<String, BiConsumer<HikariConfig, Config>> optionalHikariConfigToApplyMap = new HashMap<String, BiConsumer<HikariConfig, Config>>();
        optionalHikariConfigToApplyMap.put("cachePrepStmts", (hikariCfg, appCfg) -> hikariCfg.addDataSourceProperty("cachePrepStmts", (Object)appCfg.getString("cachePrepStmts")));
        optionalHikariConfigToApplyMap.put("prepStmtCacheSize", (hikariCfg, appCfg) -> hikariCfg.addDataSourceProperty("prepStmtCacheSize", (Object)appCfg.getString("prepStmtCacheSize")));
        optionalHikariConfigToApplyMap.put("prepStmtCacheSqlLimit", (hikariCfg, appCfg) -> hikariCfg.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)appCfg.getString("prepStmtCacheSqlLimit")));
        optionalHikariConfigToApplyMap.put(CONFIGURATION_KEY_CONNECTION_TIMEOUT, (hikariCfg, appCfg) -> hikariCfg.setConnectionTimeout((long)appCfg.getInt(CONFIGURATION_KEY_CONNECTION_TIMEOUT)));
        optionalHikariConfigToApplyMap.put(CONFIGURATION_KEY_IDLE_TIMEOUT, (hikariCfg, appCfg) -> hikariCfg.setIdleTimeout((long)appCfg.getInt(CONFIGURATION_KEY_IDLE_TIMEOUT)));
        optionalHikariConfigToApplyMap.put(CONFIGURATION_KEY_KEEPALIVE_TIME, (hikariCfg, appCfg) -> hikariCfg.setKeepaliveTime((long)appCfg.getInt(CONFIGURATION_KEY_KEEPALIVE_TIME)));
        optionalHikariConfigToApplyMap.put(CONFIGURATION_KEY_CONNECTION_INITIALISATION_SQL_QUERY, (hikariCfg, appCfg) -> hikariCfg.setConnectionInitSql(appCfg.getString(CONFIGURATION_KEY_CONNECTION_INITIALISATION_SQL_QUERY)));
        optionalHikariConfigToApplyMap.put(CONFIGURATION_KEY_CONNECTION_TEST_SQL_QUERY, (hikariCfg, appCfg) -> hikariCfg.setConnectionTestQuery(appCfg.getString(CONFIGURATION_KEY_CONNECTION_TEST_SQL_QUERY)));
        optionalHikariConfigToApplyMap.put(CONFIGURATION_KEY_AUTO_COMMIT, (hikariCfg, appCfg) -> hikariCfg.setAutoCommit(appCfg.getBoolean(CONFIGURATION_KEY_AUTO_COMMIT)));
        optionalHikariConfigToApplyMap.put(CONFIGURATION_KEY_CONNECTION_POOL_MINIMUM_IDLE, (hikariCfg, appCfg) -> hikariCfg.setMinimumIdle(appCfg.getInt(CONFIGURATION_KEY_CONNECTION_POOL_MINIMUM_IDLE)));
        optionalHikariConfigToApplyMap.put(CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_SIZE, (hikariCfg, appCfg) -> hikariCfg.setMaximumPoolSize(appCfg.getInt(CONFIGURATION_KEY_CONNECTION_POOL_MAXIMUM_SIZE)));
        optionalHikariConfigToApplyMap.put(CONFIGURATION_KEY_MAXIMUM_CONNECTION_AGE, (hikariCfg, appCfg) -> hikariCfg.setMaxLifetime((long)appCfg.getInt(CONFIGURATION_KEY_MAXIMUM_CONNECTION_AGE)));
        HashMap<String, HikariDataSource> hikariDataSourcePerNameMap = new HashMap<String, HikariDataSource>();
        for (String dbConfigurationName : this.retrieveDataSourceConfigurationNames(this.configuration)) {
            Config dbConfiguration = this.configuration.getConfig("voidframework.datasource." + dbConfigurationName);
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setPoolName(dbConfigurationName);
            hikariConfig.setJdbcUrl(dbConfiguration.getString(CONFIGURATION_KEY_URL));
            hikariConfig.setUsername(dbConfiguration.getString(CONFIGURATION_KEY_USERNAME));
            hikariConfig.setPassword(dbConfiguration.getString(CONFIGURATION_KEY_PASSWORD));
            try {
                hikariConfig.setDriverClassName(dbConfiguration.getString(CONFIGURATION_KEY_DRIVER_CLASS));
            }
            catch (RuntimeException exception) {
                throw new DataSourceException.DriverLoadFailure(dbConfiguration.getString(CONFIGURATION_KEY_DRIVER_CLASS), (Throwable)exception);
            }
            for (Map.Entry entrySet : optionalHikariConfigToApplyMap.entrySet()) {
                if (!dbConfiguration.hasPath((String)entrySet.getKey())) continue;
                ((BiConsumer)entrySet.getValue()).accept(hikariConfig, dbConfiguration);
            }
            hikariDataSourcePerNameMap.put(dbConfigurationName, new HikariDataSource(hikariConfig));
        }
        this.dataSourceManager = new DataSourceManager(hikariDataSourcePerNameMap);
        return this.dataSourceManager;
    }
}

