/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.healthcheck.checker;

import com.google.inject.Singleton;
import dev.voidframework.healthcheck.Health;
import dev.voidframework.healthcheck.HealthChecker;
import java.util.LinkedHashMap;

@Singleton
public class JavaVirtualMachineHealthChecker
implements HealthChecker {
    @Override
    public String getName() {
        return "JVM";
    }

    @Override
    public Health checkHealth() {
        LinkedHashMap<String, Object> detailsMap = new LinkedHashMap<String, Object>();
        detailsMap.put("javaVersion", Runtime.version().toString());
        detailsMap.put("maxMemory", Runtime.getRuntime().maxMemory());
        detailsMap.put("totalMemory", Runtime.getRuntime().totalMemory());
        detailsMap.put("freeMemory", Runtime.getRuntime().freeMemory());
        return new Health(Health.Status.UP, detailsMap);
    }
}

