/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.healthcheck.module;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import dev.voidframework.healthcheck.HealthCheckManager;
import dev.voidframework.healthcheck.HealthChecker;

public final class HealthCheckAnnotationListener
implements TypeListener {
    private final HealthCheckManager healthCheckManager;

    public HealthCheckAnnotationListener(HealthCheckManager healthCheckManager) {
        this.healthCheckManager = healthCheckManager;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class classType = type.getRawType();
        if (HealthChecker.class.isAssignableFrom(classType)) {
            this.healthCheckManager.registerHealthCheck(classType);
        }
    }
}

