/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.healthcheck;

import com.google.inject.Inject;
import com.google.inject.Injector;
import dev.voidframework.healthcheck.Health;
import dev.voidframework.healthcheck.HealthChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HealthCheckManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckManager.class);
    private static final Comparator<Class<? extends HealthChecker>> HEALTHCHECKER_COMPARATOR = Comparator.comparing(Class::getName);
    private final List<Class<? extends HealthChecker>> healthCheckerList = new ArrayList<Class<? extends HealthChecker>>();
    private Injector injector;

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void registerHealthCheck(Class<? extends HealthChecker> healthCheckerClassType) {
        LOGGER.debug("Register HealthCheck {}", (Object)healthCheckerClassType.getSimpleName());
        this.healthCheckerList.add(healthCheckerClassType);
    }

    public Map<String, Health> checkHealth() {
        HashMap<String, Health> healthPerNameMap = new HashMap<String, Health>();
        this.healthCheckerList.stream().sorted(HEALTHCHECKER_COMPARATOR).forEach(healthCheckerClassType -> {
            Health health;
            HealthChecker healthChecker = (HealthChecker)this.injector.getInstance(healthCheckerClassType);
            try {
                health = healthChecker.checkHealth();
            }
            catch (Throwable throwable) {
                health = new Health(Health.Status.DOWN, Collections.emptyMap());
            }
            healthPerNameMap.put(healthChecker.getName(), health);
        });
        return healthPerNameMap;
    }
}

