/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.remoteconfiguration.provider;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import dev.voidframework.core.exception.RemoteConfigurationException;
import dev.voidframework.core.remoteconfiguration.AbstractRemoteConfigurationProvider;
import dev.voidframework.core.remoteconfiguration.FileCfgObject;
import dev.voidframework.core.remoteconfiguration.KeyValueCfgObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public class HttpRemoteConfigurationProvider
extends AbstractRemoteConfigurationProvider {
    private static final String CONFIGURATION_KEY_ENDPOINT = "endpoint";
    private static final String CONFIGURATION_KEY_METHOD = "method";
    private static final String CONFIGURATION_KEY_USERNAME = "username";
    private static final String CONFIGURATION_KEY_PASSWORD = "password";
    private static final String USER_AGENT = "VoidFramework-RemoteConf-Provider";
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;

    public String getName() {
        return "HTTP";
    }

    public String getConfigurationObjectName() {
        return "http";
    }

    public void loadConfiguration(Config configuration, Consumer<KeyValueCfgObject> keyValueObjConsumer, Consumer<FileCfgObject> fileObjConsumer) throws RemoteConfigurationException {
        try {
            String remoteConfigurationContent = this.fetchRemoteConfiguration(configuration);
            if (StringUtils.isBlank((CharSequence)remoteConfigurationContent)) {
                return;
            }
            Config remoteConfiguration = ConfigFactory.parseString((String)remoteConfigurationContent);
            remoteConfiguration.entrySet().forEach(entry -> {
                String value = ((ConfigValue)entry.getValue()).render();
                if (this.isFile(value)) {
                    fileObjConsumer.accept(new FileCfgObject((String)entry.getKey(), value));
                } else {
                    keyValueObjConsumer.accept(new KeyValueCfgObject((String)entry.getKey(), value));
                }
            });
        }
        catch (ConfigException ex2) {
            if (ex2.getCause() != null) {
                throw new ConfigException.BadPath(configuration.getString(CONFIGURATION_KEY_ENDPOINT), ex2.getCause().getClass().getName(), ex2.getCause());
            }
            throw new ConfigException.ValidationFailed(Collections.singletonList(new ConfigException.ValidationProblem(configuration.getString(CONFIGURATION_KEY_ENDPOINT), ex2.origin(), ex2.getMessage())));
        }
        catch (MalformedURLException | UnknownHostException ex) {
            throw new ConfigException.BadValue(CONFIGURATION_KEY_ENDPOINT, ex.getMessage());
        }
        catch (IOException ex) {
            throw new ConfigException.IO(configuration.origin(), ex.getMessage());
        }
    }

    private String fetchRemoteConfiguration(Config configuration) throws IOException {
        URL url = new URL(configuration.getString(CONFIGURATION_KEY_ENDPOINT));
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        if (configuration.hasPath(CONFIGURATION_KEY_USERNAME)) {
            String auth = configuration.getString(CONFIGURATION_KEY_USERNAME) + ":" + configuration.getString(CONFIGURATION_KEY_PASSWORD);
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            httpConnection.setRequestProperty("Authorization", "Basic " + new String(encodedAuth));
        }
        String httpMethod = configuration.getString(CONFIGURATION_KEY_METHOD).trim().toUpperCase(Locale.ENGLISH);
        httpConnection.setRequestMethod(httpMethod);
        if (httpMethod.equals("POST")) {
            httpConnection.setDoOutput(false);
        }
        httpConnection.setRequestProperty("User-Agent", USER_AGENT);
        httpConnection.setConnectTimeout(5000);
        httpConnection.setReadTimeout(5000);
        httpConnection.connect();
        if (httpConnection.getResponseCode() / 100 == 2) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), StandardCharsets.UTF_8));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine).append("\n");
                }
                String string = response.toString();
                return string;
            }
        }
        throw new RemoteConfigurationException.FetchError(((Object)((Object)this)).getClass(), "Endpoint returns httpStatusCode " + httpConnection.getResponseCode());
    }
}

