/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.sendmail;

import com.google.inject.Inject;
import dev.voidframework.core.lifecycle.LifeCycleStart;
import dev.voidframework.core.lifecycle.LifeCycleStop;
import dev.voidframework.core.utils.IOUtils;
import dev.voidframework.sendmail.engine.MailerEngine;
import dev.voidframework.sendmail.entity.Mail;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailerManager.class);
    private final long mailQueuePollTimeout;
    private final TransferQueue<Mail> mailToSendQueue;
    private MailerEngine mailerEngine;
    private Thread worker;
    private boolean isRunning;

    public MailerManager(Duration mailQueuePollTimeout, TransferQueue<Mail> mailToSendQueue) {
        this.mailQueuePollTimeout = mailQueuePollTimeout.toMillis();
        this.mailToSendQueue = mailToSendQueue;
    }

    @Inject
    public void setMailerEngine(MailerEngine mailerEngine) {
        this.mailerEngine = mailerEngine;
    }

    @LifeCycleStart(priority=800)
    public void startSendmail() {
        this.isRunning = true;
        this.worker = new Thread(this::workerInnerLoop);
        this.worker.setName("Mailer");
        this.worker.start();
    }

    @LifeCycleStop(priority=800, gracefulStopTimeoutConfigKey="voidframework.sendmail.gracefulStopTimeout")
    public void stopSendmail() throws InterruptedException {
        this.isRunning = false;
        this.worker.join();
    }

    private void workerInnerLoop() {
        while (this.isRunning) {
            try {
                Mail mailToSend;
                while ((mailToSend = (Mail)this.mailToSendQueue.poll(this.mailQueuePollTimeout, TimeUnit.MILLISECONDS)) != null && this.tryOpenConnection()) {
                    this.trySend(mailToSend);
                }
                this.tryCloseConnection();
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean tryOpenConnection() {
        if (!this.mailerEngine.isConnected()) {
            try {
                this.mailerEngine.openConnection();
            }
            catch (Exception exception) {
                LOGGER.error("Can't open mailer connection", (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    private void trySend(Mail mailToSend) {
        try {
            this.mailerEngine.send(mailToSend);
            LOGGER.debug("Mail sent to {}", mailToSend.getRecipients());
        }
        catch (Exception exception) {
            LOGGER.error("Can't send email", (Throwable)exception);
        }
        finally {
            mailToSend.getAttachmentList().stream().map(Mail.Attachment::inputStream).forEach(IOUtils::closeWithoutException);
        }
    }

    private void tryCloseConnection() {
        try {
            this.mailerEngine.closeConnection();
        }
        catch (Exception exception) {
            LOGGER.error("Can't close mailer connection", (Throwable)exception);
        }
    }
}

