/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.sendmail.entity;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Mail {
    private final Set<String> recipientSet;
    private final Set<String> carbonCopyRecipientSet;
    private final Set<String> blindCarbonCopyRecipientSet;
    private final List<Attachment> attachmentList;
    private Charset charset = StandardCharsets.UTF_8;
    private String subject;
    private String bodyContentHtml;
    private String bodyContentText;
    private String fromAddress;
    private String fromName;
    private String replyTo;

    public Mail() {
        this.recipientSet = new HashSet<String>();
        this.carbonCopyRecipientSet = new HashSet<String>();
        this.blindCarbonCopyRecipientSet = new HashSet<String>();
        this.attachmentList = new ArrayList<Attachment>();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBodyContentHtml() {
        return this.bodyContentHtml;
    }

    public void setBodyContentHtml(String bodyContentHtml) {
        this.bodyContentHtml = bodyContentHtml;
    }

    public String getBodyContentText() {
        return this.bodyContentText;
    }

    public void setBodyContentText(String bodyContentText) {
        this.bodyContentText = bodyContentText;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFrom(String address) {
        this.fromAddress = address;
        this.fromName = null;
    }

    public void setFrom(String address, String name) {
        this.fromAddress = address;
        this.fromName = name;
    }

    public String getReplyTo() {
        return this.replyTo == null ? this.fromAddress : this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public Set<String> getRecipients() {
        return this.recipientSet;
    }

    public void addRecipient(String recipient) {
        this.recipientSet.add(recipient);
    }

    public Set<String> getCarbonCopyRecipients() {
        return this.carbonCopyRecipientSet;
    }

    public void addCarbonCopyRecipient(String carbonCopyRecipient) {
        this.carbonCopyRecipientSet.add(carbonCopyRecipient);
    }

    public Set<String> getBlindCarbonCopyRecipients() {
        return this.blindCarbonCopyRecipientSet;
    }

    public void addBlindCarbonCopyRecipient(String blindCarbonCopyRecipient) {
        this.blindCarbonCopyRecipientSet.add(blindCarbonCopyRecipient);
    }

    public List<Attachment> getAttachmentList() {
        return this.attachmentList;
    }

    public void addAttachment(String name, InputStream inputStream) {
        this.attachmentList.add(new Attachment(name, inputStream));
    }

    public record Attachment(String name, InputStream inputStream) {
    }
}

