/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.sendmail.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import dev.voidframework.core.utils.ClassResolverUtils;
import dev.voidframework.sendmail.engine.MailerEngine;

@Singleton
public final class MailerEngineProvider
implements Provider<MailerEngine> {
    private final Config configuration;
    private final Injector injector;
    private MailerEngine mailerEngine;

    @Inject
    public MailerEngineProvider(Config configuration, Injector injector) {
        this.configuration = configuration;
        this.injector = injector;
    }

    public MailerEngine get() {
        String sendmailEngineClassName;
        Class clazz;
        if (this.mailerEngine == null && this.configuration.hasPath("voidframework.sendmail.engine") && (clazz = ClassResolverUtils.forName((String)(sendmailEngineClassName = this.configuration.getString("voidframework.sendmail.engine")))) != null) {
            Injector childInjector = this.injector.createChildInjector(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(clazz);
                }
            }});
            this.mailerEngine = (MailerEngine)childInjector.getInstance(clazz);
        }
        return this.mailerEngine;
    }
}

