/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.sendmail.module;

import com.google.inject.AbstractModule;
import com.typesafe.config.Config;
import dev.voidframework.sendmail.MailerManager;
import dev.voidframework.sendmail.Sendmail;
import dev.voidframework.sendmail.engine.MailerEngine;
import dev.voidframework.sendmail.entity.Mail;
import dev.voidframework.sendmail.module.MailerEngineProvider;
import java.util.concurrent.LinkedTransferQueue;

public final class SendmailModule
extends AbstractModule {
    private final Config configuration;

    public SendmailModule(Config configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        LinkedTransferQueue<Mail> mailToSendQueue = new LinkedTransferQueue<Mail>();
        Sendmail sendmail = new Sendmail(mailToSendQueue);
        MailerManager mailerManager = new MailerManager(this.configuration.getDuration("voidframework.sendmail.mailQueuePollTimeout"), mailToSendQueue);
        this.requestInjection(mailerManager);
        this.bind(MailerEngine.class).toProvider(MailerEngineProvider.class);
        this.bind(MailerManager.class).toInstance((Object)mailerManager);
        this.bind(Sendmail.class).toInstance((Object)sendmail);
    }
}

