/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.sendmail;

import dev.voidframework.sendmail.entity.Mail;
import dev.voidframework.sendmail.exception.SendmailException;
import java.util.concurrent.TransferQueue;
import org.apache.commons.lang3.StringUtils;

public final class Sendmail {
    private final TransferQueue<Mail> mailToSendQueue;

    public Sendmail(TransferQueue<Mail> mailToSendQueue) {
        this.mailToSendQueue = mailToSendQueue;
    }

    public void send(Mail mailToSend) {
        if (mailToSend != null) {
            this.checkIsValidOrThrow(mailToSend);
            this.mailToSendQueue.add(mailToSend);
        }
    }

    private void checkIsValidOrThrow(Mail mail) throws SendmailException.InvalidMail {
        boolean isValid;
        boolean asAtLeastOneRecipient = !mail.getRecipients().isEmpty() || !mail.getCarbonCopyRecipients().isEmpty() || !mail.getBlindCarbonCopyRecipients().isEmpty();
        boolean bl = isValid = asAtLeastOneRecipient && mail.getCharset() != null && StringUtils.isNotBlank((CharSequence)mail.getFromAddress()) && StringUtils.isNotBlank((CharSequence)mail.getReplyTo()) && mail.getAttachmentList().stream().noneMatch(attachment -> attachment.inputStream() == null || StringUtils.isBlank((CharSequence)attachment.name()));
        if (!isValid) {
            throw new SendmailException.InvalidMail();
        }
    }
}

