/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.healthcheck;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import dev.voidframework.core.helper.Json;
import dev.voidframework.healthcheck.HealthCheckManager;
import dev.voidframework.web.bindable.WebController;
import dev.voidframework.web.http.NoCSRF;
import dev.voidframework.web.http.Result;
import dev.voidframework.web.http.param.RequestRoute;
import dev.voidframework.web.routing.HttpMethod;
import java.util.Map;

@WebController
public final class HealthCheckController {
    private final HealthCheckManager healthCheckManager;

    @Inject
    public HealthCheckController(HealthCheckManager healthCheckManager) {
        this.healthCheckManager = healthCheckManager;
    }

    @NoCSRF
    @RequestRoute(method=HttpMethod.GET, route="/healthcheck")
    public Result healthCheck() {
        Map healthPerNameMap = this.healthCheckManager.checkHealth();
        return Result.ok((JsonNode)Json.toJson((Object)healthPerNameMap));
    }
}

