/*
 * Decompiled with CFR 0.152.
 */
package dev.zerite.craftlib.protocol;

import dev.zerite.craftlib.protocol.ProtocolBuffer;
import dev.zerite.craftlib.protocol.ProtocolBufferKt;
import dev.zerite.craftlib.protocol.connection.NettyConnection;
import dev.zerite.craftlib.protocol.version.PacketDirection;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.junit.Assert;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u0005\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0006H\u0007J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00020\r\"\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/zerite/craftlib/protocol/ProtocolBufferTest;", "", "()V", "dummy", "Ldev/zerite/craftlib/protocol/connection/NettyConnection;", "Test Byte Array IO", "", "Test Byte IO", "Test String IO", "Test VarInt IO", "byteBuffer", "Ldev/zerite/craftlib/protocol/ProtocolBuffer;", "bytes", "", "", "craftlib-protocol"})
public final class ProtocolBufferTest {
    private final NettyConnection dummy = new NettyConnection(PacketDirection.CLIENTBOUND);

    @Test
    public final void Test VarInt IO() {
        byte[] expected = new byte[]{(byte)152, (byte)140, (byte)6, (byte)0, (byte)255, (byte)255, (byte)255, (byte)255, (byte)7};
        ProtocolBuffer buffer = ProtocolBufferKt.wrap((byte[])expected, (NettyConnection)this.dummy);
        AssertionsKt.assertEquals$default((Object)99864, (Object)buffer.readVarInt(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)0, (Object)buffer.readVarInt(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)Integer.MAX_VALUE, (Object)buffer.readVarInt(), null, (int)4, null);
        ByteBuf byteBuf = Unpooled.buffer((int)expected.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"Unpooled.buffer(expected.size)");
        ProtocolBuffer output = ProtocolBufferKt.wrap((ByteBuf)byteBuf, (NettyConnection)this.dummy);
        output.writeVarInt(99864);
        output.writeVarInt(0);
        output.writeVarInt(Integer.MAX_VALUE);
        Assert.assertArrayEquals((byte[])expected, (byte[])output.array());
        buffer.release();
        output.release();
    }

    @Test
    public final void Test Byte IO() {
        ProtocolBuffer buffer = this.byteBuffer(0, 127, 52);
        AssertionsKt.assertEquals$default((Object)0, (Object)buffer.readByte(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)127, (Object)buffer.readByte(), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)52, (Object)buffer.readByte(), null, (int)4, null);
        byte[] expected = new byte[]{0, 127, 52};
        ByteBuf byteBuf = Unpooled.buffer((int)3);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"Unpooled.buffer(3)");
        ProtocolBuffer output = ProtocolBufferKt.wrap((ByteBuf)byteBuf, (NettyConnection)this.dummy);
        output.writeByte(0);
        output.writeByte(127);
        output.writeByte(52);
        Assert.assertArrayEquals((byte[])expected, (byte[])output.array());
        buffer.release();
        output.release();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void Test Byte Array IO() {
        void it;
        ProtocolBuffer output;
        byte[] bytes = new byte[]{6, 0, 127, 61, 74, 107, 58};
        byte[] written = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])bytes, (int)1));
        ProtocolBuffer buffer = ProtocolBufferKt.wrap((byte[])bytes, (NettyConnection)this.dummy);
        Assert.assertArrayEquals((byte[])written, (byte[])ProtocolBuffer.readByteArray$default((ProtocolBuffer)buffer, null, null, (int)3, null));
        ByteBuf byteBuf = Unpooled.buffer((int)bytes.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"Unpooled.buffer(bytes.size)");
        ProtocolBuffer this_$iv = output = ProtocolBufferKt.wrap((ByteBuf)byteBuf, (NettyConnection)this.dummy);
        boolean $i$f$writeByteArray = false;
        int n = written.length;
        ProtocolBuffer $receiver = this_$iv;
        $receiver.writeVarInt((int)it);
        this_$iv.writeBytes(written);
        Assert.assertArrayEquals((byte[])bytes, (byte[])output.array());
        buffer.release();
        output.release();
    }

    @Test
    public final void Test String IO() {
        byte[] original = new byte[]{5, (byte)97, (byte)97, (byte)97, (byte)97, (byte)97, 5, (byte)122, (byte)97, (byte)120, (byte)121, (byte)101, 8, (byte)101, (byte)102, (byte)103, (byte)104, (byte)105, (byte)106, (byte)107, (byte)108};
        ProtocolBuffer buffer = ProtocolBufferKt.wrap((byte[])original, (NettyConnection)this.dummy);
        AssertionsKt.assertEquals$default((Object)"aaaaa", (Object)ProtocolBuffer.readString$default((ProtocolBuffer)buffer, null, (int)1, null), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"zaxye", (Object)ProtocolBuffer.readString$default((ProtocolBuffer)buffer, null, (int)1, null), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"efghijkl", (Object)ProtocolBuffer.readString$default((ProtocolBuffer)buffer, null, (int)1, null), null, (int)4, null);
        ByteBuf byteBuf = Unpooled.buffer((int)original.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"Unpooled.buffer(original.size)");
        ProtocolBuffer output = ProtocolBufferKt.wrap((ByteBuf)byteBuf, (NettyConnection)this.dummy);
        output.writeString("aaaaa");
        output.writeString("zaxye");
        output.writeString("efghijkl");
        Assert.assertArrayEquals((byte[])original, (byte[])output.array());
        buffer.release();
        output.release();
    }

    private final ProtocolBuffer byteBuffer(byte ... bytes) {
        return ProtocolBufferKt.wrap((byte[])Arrays.copyOf(bytes, bytes.length), (NettyConnection)this.dummy);
    }
}

