/*
 * Decompiled with CFR 0.152.
 */
package dev.zerite.craftlib.protocol.connection.io;

import dev.zerite.craftlib.protocol.ProtocolBuffer;
import dev.zerite.craftlib.protocol.ProtocolBufferKt;
import dev.zerite.craftlib.protocol.connection.NettyConnection;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Ldev/zerite/craftlib/protocol/connection/io/CompressionCodec;", "Lio/netty/handler/codec/ByteToMessageCodec;", "Lio/netty/buffer/ByteBuf;", "connection", "Ldev/zerite/craftlib/protocol/connection/NettyConnection;", "threshold", "", "(Ldev/zerite/craftlib/protocol/connection/NettyConnection;I)V", "buffer", "", "deflater", "Ljava/util/zip/Deflater;", "inflater", "Ljava/util/zip/Inflater;", "getThreshold", "()I", "setThreshold", "(I)V", "decode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "input", "out", "", "", "encode", "Companion", "craftlib-protocol"})
public final class CompressionCodec
extends ByteToMessageCodec<ByteBuf> {
    private final Deflater deflater;
    private final Inflater inflater;
    private final byte[] buffer;
    private final NettyConnection connection;
    private int threshold;
    private static final int MAX_COMPRESSED_SIZE = 0x200000;
    public static final Companion Companion = new Companion(null);

    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf input, @NotNull ByteBuf out) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        int readable = input.readableBytes();
        ProtocolBuffer buf = ProtocolBufferKt.wrap(out, this.connection);
        if (readable < this.threshold) {
            buf.writeVarInt(0);
            buf.writeBytes(input);
        } else {
            byte[] bytes = new byte[readable];
            input.readBytes(bytes);
            buf.writeVarInt(bytes.length);
            this.deflater.setInput(bytes, 0, readable);
            this.deflater.finish();
            while (!this.deflater.finished()) {
                int index = this.deflater.deflate(this.buffer);
                buf.writeBytes(this.buffer, 0, index);
            }
            this.deflater.reset();
        }
    }

    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf input, @NotNull List<Object> out) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(out, (String)"out");
        ProtocolBuffer buf = ProtocolBufferKt.wrap(input, this.connection);
        if (buf.getReadableBytes() != 0) {
            int size = buf.readVarInt();
            if (size == 0) {
                out.add(buf.readBytes(buf.getReadableBytes()));
            } else {
                if (size < this.threshold) {
                    throw (Throwable)new DecoderException("Badly compressed packet: Size (" + size + ") is below server threshold (" + this.threshold + ')');
                }
                if (size > 0x200000) {
                    throw (Throwable)new DecoderException("Badly compressed packet: Size (" + size + ") is above protocol maximum (2097152)");
                }
                byte[] bytes = new byte[buf.getReadableBytes()];
                buf.readBytes(bytes);
                this.inflater.setInput(bytes);
                byte[] inflated = new byte[size];
                this.inflater.inflate(inflated);
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])inflated);
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"Unpooled.wrappedBuffer(inflated)");
                out.add(byteBuf);
                this.inflater.reset();
            }
        }
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    public CompressionCodec(@NotNull NettyConnection connection, int threshold) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)connection), (String)"connection");
        this.connection = connection;
        this.threshold = threshold;
        this.deflater = new Deflater();
        this.inflater = new Inflater();
        this.buffer = new byte[8192];
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldev/zerite/craftlib/protocol/connection/io/CompressionCodec$Companion;", "", "()V", "MAX_COMPRESSED_SIZE", "", "craftlib-protocol"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

