/*
 * Decompiled with CFR 0.152.
 */
package dev.zerite.craftlib.protocol.connection.io;

import dev.zerite.craftlib.protocol.ProtocolBuffer;
import dev.zerite.craftlib.protocol.ProtocolBufferKt;
import dev.zerite.craftlib.protocol.connection.NettyConnection;
import dev.zerite.craftlib.protocol.util.Crypto;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.security.Key;
import java.util.List;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\f\u0010\u0017\u001a\u00020\f*\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/zerite/craftlib/protocol/connection/io/EncryptionCodec;", "Lio/netty/handler/codec/ByteToMessageCodec;", "Lio/netty/buffer/ByteBuf;", "connection", "Ldev/zerite/craftlib/protocol/connection/NettyConnection;", "key", "Ljava/security/Key;", "(Ldev/zerite/craftlib/protocol/connection/NettyConnection;Ljava/security/Key;)V", "decryptionCipher", "Ljavax/crypto/Cipher;", "encryptionCipher", "heapInput", "", "heapOutput", "decode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "buf", "out", "", "", "encode", "toBytes", "Ldev/zerite/craftlib/protocol/ProtocolBuffer;", "craftlib-protocol"})
public final class EncryptionCodec
extends ByteToMessageCodec<ByteBuf> {
    private final Cipher encryptionCipher;
    private final Cipher decryptionCipher;
    private byte[] heapInput;
    private byte[] heapOutput;
    private final NettyConnection connection;

    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf buf, @NotNull ByteBuf out) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        ProtocolBuffer buffer = ProtocolBufferKt.wrap(buf, this.connection);
        int size = buffer.getReadableBytes();
        byte[] bytes = this.toBytes(buffer);
        int outSize = this.encryptionCipher.getOutputSize(size);
        if (this.heapOutput.length < outSize) {
            this.heapOutput = new byte[outSize];
        }
        out.writeBytes(this.heapOutput, 0, this.encryptionCipher.update(bytes, 0, size, this.heapOutput, 0));
    }

    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf buf, @NotNull List<Object> out) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        Intrinsics.checkParameterIsNotNull(out, (String)"out");
        ProtocolBuffer buffer = ProtocolBufferKt.wrap(buf, this.connection);
        int size = buffer.getReadableBytes();
        byte[] bytes = this.toBytes(buffer);
        ByteBuf output = ctx.alloc().heapBuffer(this.decryptionCipher.getOutputSize(size));
        output.writerIndex(this.decryptionCipher.update(bytes, 0, size, output.array(), output.arrayOffset()));
        ByteBuf byteBuf = output;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"output");
        out.add(byteBuf);
    }

    private final byte[] toBytes(@NotNull ProtocolBuffer $this$toBytes) {
        int readable = $this$toBytes.getReadableBytes();
        if (this.heapInput.length < readable) {
            this.heapInput = new byte[readable];
        }
        $this$toBytes.readBytes(this.heapInput, 0, readable);
        return this.heapInput;
    }

    public EncryptionCodec(@NotNull NettyConnection connection, @NotNull Key key) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)connection), (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.connection = connection;
        this.encryptionCipher = Crypto.INSTANCE.get(1, key);
        this.decryptionCipher = Crypto.INSTANCE.get(2, key);
        this.heapInput = new byte[0];
        this.heapOutput = new byte[0];
    }
}

