/*
 * Decompiled with CFR 0.152.
 */
package dev.zerite.craftlib.protocol.data.world;

import dev.zerite.craftlib.protocol.data.world.Block;
import dev.zerite.craftlib.protocol.data.world.BlockLocation;
import dev.zerite.craftlib.protocol.data.world.ByteNibbleArray;
import dev.zerite.craftlib.protocol.data.world.Chunk;
import dev.zerite.craftlib.protocol.data.world.ChunkArraysOneEight;
import dev.zerite.craftlib.protocol.data.world.ChunkArraysOneSeven;
import dev.zerite.craftlib.protocol.data.world.ChunkMetadata;
import dev.zerite.craftlib.protocol.data.world.ChunkWriteOutput;
import dev.zerite.craftlib.protocol.util.ext.ArrayExtKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0015\u001a\u00020\tH\u00c2\u0003J<\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003H\u0086\u0002J#\u0010\u001b\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006#"}, d2={"Ldev/zerite/craftlib/protocol/data/world/ChunkColumn;", "", "x", "", "z", "chunks", "", "Ldev/zerite/craftlib/protocol/data/world/Chunk;", "biomes", "", "(II[Ldev/zerite/craftlib/protocol/data/world/Chunk;[B)V", "getChunks", "()[Ldev/zerite/craftlib/protocol/data/world/Chunk;", "[Ldev/zerite/craftlib/protocol/data/world/Chunk;", "getX", "()I", "getZ", "biomeAt", "component1", "component2", "component3", "component4", "copy", "(II[Ldev/zerite/craftlib/protocol/data/world/Chunk;[B)Ldev/zerite/craftlib/protocol/data/world/ChunkColumn;", "equals", "", "other", "get", "index", "Ldev/zerite/craftlib/protocol/data/world/Block;", "y", "hashCode", "toString", "", "Companion", "craftlib-protocol"})
public final class ChunkColumn {
    private final int x;
    private final int z;
    @NotNull
    private final Chunk[] chunks;
    private byte[] biomes;
    private static final int FULL_BYTE_SIZE = 4096;
    private static final int HALF_BYTE_SIZE = 2048;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Chunk get(int index) {
        return this.chunks[index];
    }

    @Nullable
    public final Block get(int x, int y, int z) {
        int chunkY = y / 16;
        return this.get(chunkY).get(x, y - chunkY * 16, z);
    }

    public final int biomeAt(int x, int z) {
        return this.biomes[x + 16 * z];
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type dev.zerite.craftlib.protocol.data.world.ChunkColumn");
        }
        ChunkColumn cfr_ignored_0 = (ChunkColumn)object2;
        if (this.x != ((ChunkColumn)other).x) {
            return false;
        }
        if (this.z != ((ChunkColumn)other).z) {
            return false;
        }
        Object[] objectArray = this.chunks;
        Object[] objectArray2 = ((ChunkColumn)other).chunks;
        boolean bl = false;
        if (!Arrays.equals(objectArray, objectArray2)) {
            return false;
        }
        objectArray = this.biomes;
        objectArray2 = ((ChunkColumn)other).biomes;
        bl = false;
        return Arrays.equals((byte[])objectArray, (byte[])objectArray2);
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.z;
        Object[] objectArray = this.chunks;
        int n = 31 * result;
        boolean bl = false;
        int n2 = Arrays.hashCode(objectArray);
        result = n + n2;
        objectArray = this.biomes;
        n = 31 * result;
        bl = false;
        n2 = Arrays.hashCode((byte[])objectArray);
        result = n + n2;
        return result;
    }

    public final int getX() {
        return this.x;
    }

    public final int getZ() {
        return this.z;
    }

    @NotNull
    public final Chunk[] getChunks() {
        return this.chunks;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkColumn(int x, int z, @NotNull Chunk[] chunks, @NotNull byte[] biomes) {
        Intrinsics.checkParameterIsNotNull((Object)chunks, (String)"chunks");
        Intrinsics.checkParameterIsNotNull((Object)biomes, (String)"biomes");
        this.x = x;
        this.z = z;
        this.chunks = chunks;
        this.biomes = biomes;
        if (this.biomes.length < 256) {
            byte[] byArray;
            int n = 256;
            ChunkColumn chunkColumn = this;
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byte by;
                void it;
                int n2 = i;
                int n3 = i;
                byArray = byArray2;
                boolean bl = false;
                Byte by2 = ArraysKt.getOrNull((byte[])this.biomes, (int)it);
                byArray[n3] = by = by2 != null ? by2 : (byte)0;
            }
            byArray = byArray2;
            chunkColumn.biomes = byArray;
        }
    }

    public static final /* synthetic */ void access$setBiomes$p(ChunkColumn $this, byte[] byArray) {
        $this.biomes = byArray;
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.z;
    }

    @NotNull
    public final Chunk[] component3() {
        return this.chunks;
    }

    private final byte[] component4() {
        return this.biomes;
    }

    @NotNull
    public final ChunkColumn copy(int x, int z, @NotNull Chunk[] chunks, @NotNull byte[] biomes) {
        Intrinsics.checkParameterIsNotNull((Object)chunks, (String)"chunks");
        Intrinsics.checkParameterIsNotNull((Object)biomes, (String)"biomes");
        return new ChunkColumn(x, z, chunks, biomes);
    }

    public static /* synthetic */ ChunkColumn copy$default(ChunkColumn chunkColumn, int n, int n2, Chunk[] chunkArray, byte[] byArray, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = chunkColumn.x;
        }
        if ((n3 & 2) != 0) {
            n2 = chunkColumn.z;
        }
        if ((n3 & 4) != 0) {
            chunkArray = chunkColumn.chunks;
        }
        if ((n3 & 8) != 0) {
            byArray = chunkColumn.biomes;
        }
        return chunkColumn.copy(n, n2, chunkArray, byArray);
    }

    @NotNull
    public String toString() {
        return "ChunkColumn(x=" + this.x + ", z=" + this.z + ", chunks=" + Arrays.toString(this.chunks) + ", biomes=" + Arrays.toString(this.biomes) + ")";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rJ*\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\rJ\"\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/zerite/craftlib/protocol/data/world/ChunkColumn$Companion;", "", "()V", "FULL_BYTE_SIZE", "", "HALF_BYTE_SIZE", "readOneEight", "Ldev/zerite/craftlib/protocol/data/world/ChunkColumn;", "data", "", "metadata", "Ldev/zerite/craftlib/protocol/data/world/ChunkMetadata;", "hasSkyLight", "", "readBiomes", "readOneSeven", "writeOneEight", "Ldev/zerite/craftlib/protocol/data/world/ChunkWriteOutput;", "column", "writeBiomes", "writeOneSeven", "craftlib-protocol"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ChunkColumn readOneSeven(@NotNull byte[] data, @NotNull ChunkMetadata metadata, boolean hasSkyLight, boolean readBiomes) {
            byte[] byArray;
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            int n;
            int it;
            int n2;
            int n3;
            int n4;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
            int marker = 0;
            int n5 = 16;
            int n6 = metadata.getChunkZ();
            int n7 = metadata.getChunkX();
            ChunkArraysOneSeven[] chunkArraysOneSevenArray = new ChunkArraysOneSeven[n5];
            int n8 = 0;
            while (n8 < n5) {
                ChunkArraysOneSeven chunkArraysOneSeven;
                int n9 = n8;
                int n10 = n8++;
                object = chunkArraysOneSevenArray;
                boolean bl = false;
                object[n10] = chunkArraysOneSeven = new ChunkArraysOneSeven();
            }
            object = chunkArraysOneSevenArray;
            Object[] objectArray = object;
            int n11 = 0;
            n8 = 0;
            ChunkArraysOneSeven[] $this$apply = objectArray;
            boolean bl = false;
            int n12 = 0;
            Iterable $this$count$iv = (Iterable)new IntRange(n12, 15);
            int $i$f$count = 0;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n4 = 0;
            } else {
                int count$iv = 0;
                Iterator iterator = $this$count$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it2 = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!((metadata.getPrimaryBitmap() & 1 << it2) != 0)) continue;
                    it2 = ++count$iv;
                    bl2 = false;
                    if (it2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n4 = count$iv;
            }
            int masked = n4;
            $i$f$count = 0;
            Iterable $this$count$iv2 = (Iterable)new IntRange($i$f$count, 15);
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n3 = 0;
            } else {
                int count$iv = 0;
                Iterator element$iv = $this$count$iv2.iterator();
                while (element$iv.hasNext()) {
                    int element$iv2;
                    int it3 = element$iv2 = ((IntIterator)element$iv).nextInt();
                    boolean bl3 = false;
                    if (!((metadata.getAddBitmap() & 1 << it3) != 0)) continue;
                    it3 = ++count$iv;
                    n2 = 0;
                    if (it3 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n3 = count$iv;
            }
            int maskedAdd = n3;
            int i = 0;
            ChunkArraysOneSeven[] $this$forEachIndexed$iv = $this$apply;
            boolean $i$f$forEachIndexed = false;
            int index$iv2 = 0;
            for (ChunkArraysOneSeven item$iv : $this$forEachIndexed$iv) {
                byte[] byArray2;
                byte[] byArray3;
                byte[] byArray4;
                void chunk;
                int n13 = index$iv2++;
                ChunkArraysOneSeven chunkArraysOneSeven = item$iv;
                it = n13;
                boolean bl4 = false;
                if ((metadata.getPrimaryBitmap() & 1 << it) == 0) {
                    chunk.setBlockTypes(new byte[4096]);
                    chunk.setMetadata(new ByteNibbleArray(new byte[2048]));
                    chunk.setBlockLight(new ByteNibbleArray(new byte[2048]));
                    chunk.setSkyLight(new ByteNibbleArray(new byte[2048]));
                    chunk.setAddArray(new ByteNibbleArray(new byte[2048]));
                    continue;
                }
                int bytesPosition = i * 4096;
                byte[] byArray5 = data;
                n = bytesPosition;
                int n14 = bytesPosition + 4096;
                void var28_64 = chunk;
                boolean bl5 = false;
                byte[] byArray6 = ArraysKt.copyOfRange((byte[])byArray5, (int)n, (int)n14);
                var28_64.setBlockTypes(byArray6);
                byArray5 = data;
                n = bytesPosition += (masked - i) * 4096 + i * 2048;
                n14 = bytesPosition + 2048;
                var28_64 = chunk;
                bl5 = false;
                byte[] byArray7 = byArray4 = ArraysKt.copyOfRange((byte[])byArray5, (int)n, (int)n14);
                var28_64.setMetadata(new ByteNibbleArray(byArray7));
                byArray5 = data;
                n = bytesPosition += masked * 2048;
                n14 = bytesPosition + 2048;
                var28_64 = chunk;
                bl5 = false;
                byte[] byArray8 = byArray4 = ArraysKt.copyOfRange((byte[])byArray5, (int)n, (int)n14);
                var28_64.setBlockLight(new ByteNibbleArray(byArray8));
                bytesPosition += masked * 2048;
                marker += 8192;
                void v3 = chunk;
                if (hasSkyLight) {
                    byArray5 = data;
                    n = bytesPosition;
                    n14 = bytesPosition + 2048;
                    var28_64 = v3;
                    bl5 = false;
                    byArray4 = ArraysKt.copyOfRange((byte[])byArray5, (int)n, (int)n14);
                    byArray5 = byArray4;
                    n = 0;
                    n14 = 0;
                    byte[] $this$apply2 = byArray5;
                    boolean bl6 = false;
                    bytesPosition += maskedAdd * 2048;
                    marker += 2048;
                    byArray4 = byArray5;
                    v3 = var28_64;
                    byArray3 = byArray4;
                } else {
                    byArray3 = new byte[]{};
                }
                byte[] byArray9 = byArray3;
                v3.setSkyLight(new ByteNibbleArray(byArray9));
                void v5 = chunk;
                if ((metadata.getAddBitmap() & 1 << it) != 0) {
                    byArray5 = data;
                    n = bytesPosition;
                    n14 = bytesPosition + 2048;
                    var28_64 = v5;
                    boolean $this$apply2 = false;
                    byArray4 = ArraysKt.copyOfRange((byte[])byArray5, (int)n, (int)n14);
                    byArray5 = byArray4;
                    n = 0;
                    n14 = 0;
                    byte[] $this$apply22 = byArray5;
                    boolean bl7 = false;
                    bytesPosition += masked * 2048;
                    marker += 2048;
                    byArray4 = byArray5;
                    v5 = var28_64;
                    byArray2 = byArray4;
                } else {
                    byArray2 = new byte[]{};
                }
                byte[] byArray10 = byArray2;
                v5.setAddArray(new ByteNibbleArray(byArray10));
                int n15 = i;
                i = n15 + 1;
            }
            object = objectArray;
            objectArray = (Object[])object;
            boolean $i$f$map = false;
            void var8_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                ChunkArraysOneSeven index$iv2 = (ChunkArraysOneSeven)item$iv$iv;
                object = destination$iv$iv;
                boolean bl8 = false;
                Block[] blockData = new Block[4096];
                masked = 0;
                n2 = 16;
                while (masked < n2) {
                    void y;
                    int item$iv = 0;
                    int n16 = 16;
                    while (item$iv < n16) {
                        void z;
                        it = 0;
                        int n17 = 16;
                        while (it < n17) {
                            void it4;
                            void x;
                            int index = Chunk.Companion.index((int)x, (int)y, (int)z);
                            if (index <= it4.getBlockTypes().length) {
                                byte[] byArray11 = it4.getBlockTypes();
                                n = 0;
                                if (!(byArray11.length == 0)) {
                                    Block block;
                                    int type = it4.getBlockTypes()[index] & 0xFF | it4.getAddArray().get(index, 0) << 8;
                                    int meta = it4.getMetadata().get(index, 0);
                                    int light = it4.getBlockLight().get(index, 0);
                                    int sky = it4.getSkyLight().get(index, 0);
                                    Block[] blockArray = blockData;
                                    int n18 = index;
                                    if (type == 0 && meta == 0 && light == 0 && sky == 0) {
                                        block = null;
                                    } else {
                                        Block block2 = new Block(type, meta, light, sky);
                                        int n19 = n18;
                                        Block[] blockArray2 = blockArray;
                                        boolean bl9 = false;
                                        boolean bl10 = false;
                                        Block $this$apply3 = block2;
                                        boolean bl11 = false;
                                        $this$apply3.setLocation(new BlockLocation((int)x, (int)y, (int)z));
                                        Block block3 = block2;
                                        blockArray = blockArray2;
                                        n18 = n19;
                                        block = block3;
                                    }
                                    blockArray[n18] = block;
                                }
                            }
                            ++x;
                        }
                        ++z;
                    }
                    ++y;
                }
                Chunk chunk = new Chunk(blockData);
                object.add(chunk);
            }
            object = (List)destination$iv$iv;
            $this$map$iv = (Collection)object;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Chunk[] chunkArray = thisCollection$iv.toArray(new Chunk[0]);
            if (chunkArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            object = chunkArray;
            int n20 = n7;
            int n21 = n6;
            Object object2 = (Chunk[])object;
            if (readBiomes) {
                objectArray = data;
                n11 = marker;
                int n22 = marker + 256;
                object = object2;
                n6 = n21;
                n7 = n20;
                boolean bl12 = false;
                byte[] byArray12 = ArraysKt.copyOfRange((byte[])objectArray, (int)n11, (int)n22);
                n20 = n7;
                n21 = n6;
                object2 = object;
                byArray = byArray12;
            } else {
                byArray = new byte[256];
            }
            byte[] byArray13 = byArray;
            Chunk[] chunkArray2 = object2;
            int n23 = n21;
            int n24 = n20;
            return new ChunkColumn(n24, n23, chunkArray2, byArray13);
        }

        public static /* synthetic */ ChunkColumn readOneSeven$default(Companion companion, byte[] byArray, ChunkMetadata chunkMetadata, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = chunkMetadata.getBiomes();
            }
            return companion.readOneSeven(byArray, chunkMetadata, bl, bl2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ChunkColumn readOneEight(@NotNull byte[] data, @NotNull ChunkMetadata metadata, boolean hasSkyLight, boolean readBiomes) {
            byte[] byArray;
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            int n;
            byte[] byArray2;
            boolean bl;
            Object object;
            int n2;
            int n3;
            byte[] byArray3;
            ChunkArraysOneEight chunk;
            int it;
            Object object2;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
            int marker = 0;
            int n4 = 16;
            int n5 = metadata.getChunkZ();
            int n6 = metadata.getChunkX();
            ChunkArraysOneEight[] chunkArraysOneEightArray = new ChunkArraysOneEight[n4];
            int n7 = 0;
            while (n7 < n4) {
                ChunkArraysOneEight chunkArraysOneEight;
                int n8 = n7;
                int n9 = n7++;
                object2 = chunkArraysOneEightArray;
                boolean bl2 = false;
                object2[n9] = chunkArraysOneEight = new ChunkArraysOneEight();
            }
            object2 = chunkArraysOneEightArray;
            Object[] objectArray = object2;
            int n10 = 0;
            n7 = 0;
            ChunkArraysOneEight[] $this$apply = objectArray;
            boolean bl3 = false;
            ChunkArraysOneEight[] $this$forEachIndexed$iv = $this$apply;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (ChunkArraysOneEight item$iv : $this$forEachIndexed$iv) {
                int n11 = index$iv++;
                ChunkArraysOneEight chunkArraysOneEight = item$iv;
                it = n11;
                boolean bl4 = false;
                if ((metadata.getPrimaryBitmap() & 1 << it) == 0) {
                    chunk.setBlockTypes(new short[4096]);
                    continue;
                }
                byArray3 = data;
                n3 = marker;
                n2 = marker + 8192;
                void var24_40 = chunk;
                boolean bl5 = false;
                object = ArraysKt.copyOfRange((byte[])byArray3, (int)n3, (int)n2);
                var24_40.setBlockTypes(ArrayExtKt.toShortArray((byte[])object));
                marker += 8192;
            }
            $this$forEachIndexed$iv = $this$apply;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (ChunkArraysOneEight item$iv : $this$forEachIndexed$iv) {
                int n12 = index$iv++;
                chunk = item$iv;
                it = n12;
                boolean bl6 = false;
                if ((metadata.getPrimaryBitmap() & 1 << it) == 0) {
                    chunk.setBlockLight(new ByteNibbleArray(new byte[2048]));
                    continue;
                }
                byArray3 = data;
                n3 = marker;
                n2 = marker + 2048;
                object = chunk;
                bl = false;
                byte[] byArray4 = byArray2 = ArraysKt.copyOfRange((byte[])byArray3, (int)n3, (int)n2);
                ((ChunkArraysOneEight)object).setBlockLight(new ByteNibbleArray(byArray4));
                marker += 2048;
            }
            $this$forEachIndexed$iv = $this$apply;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (ChunkArraysOneEight item$iv : $this$forEachIndexed$iv) {
                int n13 = index$iv++;
                chunk = item$iv;
                it = n13;
                n = 0;
                if (!hasSkyLight || (metadata.getPrimaryBitmap() & 1 << it) == 0) {
                    chunk.setSkyLight(new ByteNibbleArray(new byte[2048]));
                    continue;
                }
                byArray3 = data;
                n3 = marker;
                n2 = marker + 2048;
                object = chunk;
                bl = false;
                byte[] byArray5 = byArray2 = ArraysKt.copyOfRange((byte[])byArray3, (int)n3, (int)n2);
                ((ChunkArraysOneEight)object).setSkyLight(new ByteNibbleArray(byArray5));
                marker += 2048;
            }
            object2 = objectArray;
            objectArray = (Object[])object2;
            boolean $i$f$map = false;
            void var8_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                ChunkArraysOneEight chunkArraysOneEight = (ChunkArraysOneEight)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl7 = false;
                Block[] blockData = new Block[4096];
                int chunk2 = 0;
                int n14 = 16;
                while (chunk2 < n14) {
                    void y;
                    n = 0;
                    int n15 = 16;
                    while (n < n15) {
                        void z;
                        n3 = 0;
                        n2 = 16;
                        while (n3 < n2) {
                            void it2;
                            void x;
                            int index = Chunk.Companion.index((int)x, (int)y, (int)z);
                            if (index <= it2.getBlockTypes().length) {
                                short[] sArray = it2.getBlockTypes();
                                boolean bl8 = false;
                                if (!(sArray.length == 0)) {
                                    Block block;
                                    short typeData = it2.getBlockTypes()[index];
                                    int type = typeData >> 4;
                                    int meta = typeData & 0xF;
                                    int light = it2.getBlockLight().get(index, 0);
                                    int sky = it2.getSkyLight().get(index, 0);
                                    Block[] blockArray = blockData;
                                    int n16 = index;
                                    if (type == 0 && meta == 0 && light == 0 && sky == 0) {
                                        block = null;
                                    } else {
                                        Block block2 = new Block(type, meta, light, sky);
                                        int n17 = n16;
                                        Block[] blockArray2 = blockArray;
                                        boolean bl9 = false;
                                        boolean bl10 = false;
                                        Block $this$apply2 = block2;
                                        boolean bl11 = false;
                                        $this$apply2.setLocation(new BlockLocation((int)x, (int)y, (int)z));
                                        Block block3 = block2;
                                        blockArray = blockArray2;
                                        n16 = n17;
                                        block = block3;
                                    }
                                    blockArray[n16] = block;
                                }
                            }
                            ++x;
                        }
                        ++z;
                    }
                    ++y;
                }
                Chunk chunk3 = new Chunk(blockData);
                object2.add(chunk3);
            }
            object2 = (List)destination$iv$iv;
            $this$map$iv = (Collection)object2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Chunk[] chunkArray = thisCollection$iv.toArray(new Chunk[0]);
            if (chunkArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            object2 = chunkArray;
            int n18 = n6;
            int n19 = n5;
            Object object3 = (Chunk[])object2;
            if (readBiomes && metadata.getPrimaryBitmap() != 0) {
                objectArray = data;
                n10 = marker;
                int n20 = marker + 256;
                object2 = object3;
                n5 = n19;
                n6 = n18;
                boolean bl12 = false;
                byte[] byArray6 = ArraysKt.copyOfRange((byte[])objectArray, (int)n10, (int)n20);
                n18 = n6;
                n19 = n5;
                object3 = object2;
                byArray = byArray6;
            } else {
                byArray = new byte[256];
            }
            byte[] byArray7 = byArray;
            Chunk[] chunkArray2 = object3;
            int n21 = n19;
            int n22 = n18;
            return new ChunkColumn(n22, n21, chunkArray2, byArray7);
        }

        public static /* synthetic */ ChunkColumn readOneEight$default(Companion companion, byte[] byArray, ChunkMetadata chunkMetadata, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = chunkMetadata.getBiomes();
            }
            return companion.readOneEight(byArray, chunkMetadata, bl, bl2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ChunkWriteOutput writeOneSeven(@NotNull ChunkColumn column, boolean hasSkyLight, boolean writeBiomes) {
            int n;
            int n2;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            int primaryBitmap = 0;
            int addBitmap = 0;
            byte[] output = new byte[196864];
            int outputPos = 0;
            Chunk[] $this$mapIndexed$iv = column.getChunks();
            boolean $i$f$mapIndexed = false;
            Chunk[] chunkArray = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                int n3 = index$iv$iv++;
                void var18_26 = item$iv$iv;
                n2 = n3;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ChunkArraysOneSeven chunkArraysOneSeven = new ChunkArraysOneSeven();
                boolean bl2 = false;
                boolean bl3 = false;
                ChunkArraysOneSeven $this$apply = chunkArraysOneSeven;
                boolean bl4 = false;
                $this$apply.setBlockTypes(new byte[4096]);
                $this$apply.setMetadata(new ByteNibbleArray(new byte[2048]));
                $this$apply.setBlockLight(new ByteNibbleArray(new byte[2048]));
                $this$apply.setSkyLight(new ByteNibbleArray(new byte[2048]));
                $this$apply.setAddArray(new ByteNibbleArray(new byte[2048]));
                boolean foundBlock = false;
                boolean foundAdd = false;
                int n4 = 0;
                int n5 = 16;
                while (n4 < n5) {
                    void y;
                    int n6 = 0;
                    int n7 = 16;
                    while (n6 < n7) {
                        void z;
                        int n8 = 0;
                        int n9 = 16;
                        while (n8 < n9) {
                            void it;
                            void x;
                            int index = Chunk.Companion.index((int)x, (int)y, (int)z);
                            if (it.get((int)x, (int)y, (int)z) == null) {
                            } else {
                                Block block;
                                int add = (block.getId() & 0xF00) >> 8;
                                $this$apply.getBlockTypes()[index] = (byte)(block.getId() & 0xFF);
                                $this$apply.getMetadata().set(index, block.getMetadata());
                                $this$apply.getBlockLight().set(index, block.getBlockLight());
                                $this$apply.getSkyLight().set(index, block.getSkyLight());
                                $this$apply.getAddArray().set(index, add);
                                if (block.getId() != 0 || block.getMetadata() != 0) {
                                    foundBlock = true;
                                }
                                if (add != 0) {
                                    foundAdd = true;
                                }
                            }
                            ++x;
                        }
                        ++z;
                    }
                    ++y;
                }
                if (foundBlock) {
                    primaryBitmap |= 1 << i;
                }
                if (foundAdd) {
                    addBitmap |= 1 << i;
                }
                ChunkArraysOneSeven chunkArraysOneSeven2 = chunkArraysOneSeven;
                collection.add(chunkArraysOneSeven2);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ChunkArraysOneSeven[] chunkArraysOneSevenArray = thisCollection$iv.toArray(new ChunkArraysOneSeven[0]);
            if (chunkArraysOneSevenArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ChunkArraysOneSeven[] chunkArraysOneSevenArray2 = chunkArraysOneSevenArray;
            boolean bl = false;
            boolean bl5 = false;
            ChunkArraysOneSeven[] $this$apply = chunkArraysOneSevenArray2;
            boolean bl6 = false;
            index$iv$iv = 0;
            Iterable $this$count$iv = (Iterable)new IntRange(index$iv$iv, 15);
            int $i$f$count = 0;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Iterator iterator = $this$count$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl7 = false;
                    if (!((primaryBitmap & 1 << it) != 0)) continue;
                    int n10 = ++count$iv;
                    n2 = 0;
                    if (n10 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int masked = n;
            int i = 0;
            $i$f$count = 0;
            int n11 = 15;
            while ($i$f$count <= n11) {
                void it;
                ChunkArraysOneSeven chunk = $this$apply[it];
                if ((primaryBitmap & 1 << it) != 0) {
                    int bytesPosition = i * 4096;
                    System.arraycopy(chunk.getBlockTypes(), 0, output, bytesPosition, 4096);
                    System.arraycopy(chunk.getMetadata().getData(), 0, output, bytesPosition += (masked - i) * 4096 + i * 2048, chunk.getMetadata().getData().length);
                    System.arraycopy(chunk.getBlockLight().getData(), 0, output, bytesPosition += masked * 2048, chunk.getBlockLight().getData().length);
                    bytesPosition += masked * 2048;
                    outputPos += 8192;
                    if (hasSkyLight) {
                        System.arraycopy(chunk.getSkyLight().getData(), 0, output, bytesPosition, 2048);
                        bytesPosition += masked * 2048;
                        outputPos += 2048;
                    }
                    if ((addBitmap & 1 << it) != 0) {
                        System.arraycopy(chunk.getSkyLight().getData(), 0, output, bytesPosition, 2048);
                        bytesPosition += masked * 2048;
                        outputPos += 2048;
                    }
                    ++i;
                }
                ++it;
            }
            if (writeBiomes) {
                System.arraycopy(column.biomes, 0, output, outputPos, 256);
                outputPos += 256;
            }
            return new ChunkWriteOutput(primaryBitmap, addBitmap, ArrayExtKt.trim(output, outputPos));
        }

        public static /* synthetic */ ChunkWriteOutput writeOneSeven$default(Companion companion, ChunkColumn chunkColumn, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.writeOneSeven(chunkColumn, bl, bl2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ChunkWriteOutput writeOneEight(@NotNull ChunkColumn column, boolean hasSkyLight, boolean writeBiomes) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            int primaryBitmap = 0;
            byte[] output = new byte[196864];
            int outputPos = 0;
            Chunk[] $this$mapIndexed$iv = column.getChunks();
            boolean $i$f$mapIndexed = false;
            Chunk[] chunkArray = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                int n = index$iv$iv++;
                void var17_22 = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                ChunkArraysOneEight chunkArraysOneEight = new ChunkArraysOneEight();
                boolean bl2 = false;
                boolean bl3 = false;
                ChunkArraysOneEight $this$apply = chunkArraysOneEight;
                boolean bl4 = false;
                $this$apply.setBlockTypes(new short[4096]);
                $this$apply.setBlockLight(new ByteNibbleArray(new byte[2048]));
                $this$apply.setSkyLight(new ByteNibbleArray(new byte[2048]));
                boolean foundBlock = false;
                int n3 = 0;
                int n4 = 16;
                while (n3 < n4) {
                    void y;
                    int n5 = 0;
                    int n6 = 16;
                    while (n5 < n6) {
                        void z;
                        int n7 = 0;
                        int n8 = 16;
                        while (n7 < n8) {
                            void it;
                            void x;
                            int index = Chunk.Companion.index((int)x, (int)y, (int)z);
                            if (it.get((int)x, (int)y, (int)z) == null) {
                            } else {
                                Block block;
                                $this$apply.getBlockTypes()[index] = (short)(block.getId() << 4 | block.getMetadata() & 0xF);
                                $this$apply.getBlockLight().set(index, block.getBlockLight());
                                $this$apply.getSkyLight().set(index, block.getSkyLight());
                                if (block.getId() != 0 || block.getMetadata() != 0) {
                                    foundBlock = true;
                                }
                            }
                            ++x;
                        }
                        ++z;
                    }
                    ++y;
                }
                if (foundBlock) {
                    void i;
                    primaryBitmap |= 1 << i;
                }
                ChunkArraysOneEight chunkArraysOneEight2 = chunkArraysOneEight;
                collection.add(chunkArraysOneEight2);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ChunkArraysOneEight[] chunkArraysOneEightArray = thisCollection$iv.toArray(new ChunkArraysOneEight[0]);
            if (chunkArraysOneEightArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ChunkArraysOneEight[] chunkArraysOneEightArray2 = chunkArraysOneEightArray;
            boolean bl = false;
            boolean bl5 = false;
            ChunkArraysOneEight[] $this$apply = chunkArraysOneEightArray2;
            boolean bl6 = false;
            ChunkArraysOneEight[] $this$forEachIndexed$iv = $this$apply;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (ChunkArraysOneEight item$iv : $this$forEachIndexed$iv) {
                void chunk;
                int n = index$iv++;
                ChunkArraysOneEight bl7 = item$iv;
                int it = n;
                boolean bl8 = false;
                if ((primaryBitmap & 1 << it) == 0) continue;
                System.arraycopy(ArrayExtKt.toByteArray(chunk.getBlockTypes()), 0, output, outputPos, 8192);
                outputPos += 8192;
            }
            $this$forEachIndexed$iv = $this$apply;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (ChunkArraysOneEight item$iv : $this$forEachIndexed$iv) {
                int n = index$iv++;
                ChunkArraysOneEight chunk = item$iv;
                int it = n;
                boolean bl9 = false;
                if ((primaryBitmap & 1 << it) == 0) continue;
                System.arraycopy(chunk.getBlockLight().getData(), 0, output, outputPos, 2048);
                outputPos += 2048;
            }
            if (hasSkyLight) {
                $this$forEachIndexed$iv = $this$apply;
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (ChunkArraysOneEight item$iv : $this$forEachIndexed$iv) {
                    int n = index$iv++;
                    ChunkArraysOneEight chunk = item$iv;
                    int it = n;
                    boolean bl10 = false;
                    if ((primaryBitmap & 1 << it) == 0) continue;
                    System.arraycopy(chunk.getSkyLight().getData(), 0, output, outputPos, 2048);
                    outputPos += 2048;
                }
            }
            if (writeBiomes) {
                System.arraycopy(column.biomes, 0, output, outputPos, 256);
                outputPos += 256;
            }
            return new ChunkWriteOutput(primaryBitmap, 0, ArrayExtKt.trim(output, outputPos));
        }

        public static /* synthetic */ ChunkWriteOutput writeOneEight$default(Companion companion, ChunkColumn chunkColumn, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return companion.writeOneEight(chunkColumn, bl, bl2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

