package dev.zerite.craftlib.protocol.packet.play.server.inventory

import dev.zerite.craftlib.protocol.Packet
import dev.zerite.craftlib.protocol.PacketIO
import dev.zerite.craftlib.protocol.ProtocolBuffer
import dev.zerite.craftlib.protocol.connection.NettyConnection
import dev.zerite.craftlib.protocol.version.ProtocolVersion

/**
 * This packet is sent from the server to the client when a window is forcibly closed,
 * such as when a chest is destroyed while it's open.
 *
 * Note, notchian clients send a close window message with window id 0 to close their
 * inventory even though there is never an Open Window message for inventory.
 *
 * @author Koding
 * @since  0.1.0-SNAPSHOT
 */
data class ServerPlayCloseWindowPacket(
    var windowId: Int
) : Packet() {
    companion object : PacketIO<ServerPlayCloseWindowPacket> {
        override fun read(
            buffer: ProtocolBuffer,
            version: ProtocolVersion,
            connection: NettyConnection
        ) = ServerPlayCloseWindowPacket(
            buffer.readUnsignedByte().toInt()
        )

        override fun write(
            buffer: ProtocolBuffer,
            version: ProtocolVersion,
            packet: ServerPlayCloseWindowPacket,
            connection: NettyConnection
        ) {
            buffer.writeByte(packet.windowId)
        }
    }
}