package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class RenewCertificateRequest(certificateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.RenewCertificateRequest = {
    import RenewCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.RenewCertificateRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.RenewCertificateRequest.ReadOnly =
    zio.aws.acm.model.RenewCertificateRequest.wrap(buildAwsValue())
}
object RenewCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.RenewCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.RenewCertificateRequest =
      zio.aws.acm.model.RenewCertificateRequest(certificateArn)
    def certificateArn: Arn
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.RenewCertificateRequest
  ) extends zio.aws.acm.model.RenewCertificateRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.RenewCertificateRequest
  ): zio.aws.acm.model.RenewCertificateRequest.ReadOnly = new Wrapper(impl)
}
