package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{Arn, IdempotencyToken, DomainNameString}
import scala.jdk.CollectionConverters._
final case class RequestCertificateRequest(
    domainName: DomainNameString,
    validationMethod: Option[zio.aws.acm.model.ValidationMethod] = None,
    subjectAlternativeNames: Option[Iterable[DomainNameString]] = None,
    idempotencyToken: Option[IdempotencyToken] = None,
    domainValidationOptions: Option[
      Iterable[zio.aws.acm.model.DomainValidationOption]
    ] = None,
    options: Option[zio.aws.acm.model.CertificateOptions] = None,
    certificateAuthorityArn: Option[Arn] = None,
    tags: Option[Iterable[zio.aws.acm.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.RequestCertificateRequest = {
    import RequestCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.RequestCertificateRequest
      .builder()
      .domainName(DomainNameString.unwrap(domainName): java.lang.String)
      .optionallyWith(validationMethod.map(value => value.unwrap))(
        _.validationMethod
      )
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            DomainNameString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .optionallyWith(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationOptions)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.RequestCertificateRequest.ReadOnly =
    zio.aws.acm.model.RequestCertificateRequest.wrap(buildAwsValue())
}
object RequestCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.RequestCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.RequestCertificateRequest =
      zio.aws.acm.model.RequestCertificateRequest(
        domainName,
        validationMethod.map(value => value),
        subjectAlternativeNames.map(value => value),
        idempotencyToken.map(value => value),
        domainValidationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        options.map(value => value.asEditable),
        certificateAuthorityArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainName: DomainNameString
    def validationMethod: Option[zio.aws.acm.model.ValidationMethod]
    def subjectAlternativeNames: Option[List[DomainNameString]]
    def idempotencyToken: Option[IdempotencyToken]
    def domainValidationOptions
        : Option[List[zio.aws.acm.model.DomainValidationOption.ReadOnly]]
    def options: Option[zio.aws.acm.model.CertificateOptions.ReadOnly]
    def certificateAuthorityArn: Option[Arn]
    def tags: Option[List[zio.aws.acm.model.Tag.ReadOnly]]
    def getDomainName: ZIO[Any, Nothing, DomainNameString] =
      ZIO.succeed(domainName)
    def getValidationMethod
        : ZIO[Any, AwsError, zio.aws.acm.model.ValidationMethod] =
      AwsError.unwrapOptionField("validationMethod", validationMethod)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[DomainNameString]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getDomainValidationOptions: ZIO[Any, AwsError, List[
      zio.aws.acm.model.DomainValidationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationOptions",
      domainValidationOptions
    )
    def getOptions
        : ZIO[Any, AwsError, zio.aws.acm.model.CertificateOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.acm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.RequestCertificateRequest
  ) extends zio.aws.acm.model.RequestCertificateRequest.ReadOnly {
    override val domainName: DomainNameString =
      zio.aws.acm.model.primitives.DomainNameString(impl.domainName())
    override val validationMethod: Option[zio.aws.acm.model.ValidationMethod] =
      scala
        .Option(impl.validationMethod())
        .map(value => zio.aws.acm.model.ValidationMethod.wrap(value))
    override val subjectAlternativeNames: Option[List[DomainNameString]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.primitives.DomainNameString(item)
        }.toList
      )
    override val idempotencyToken: Option[IdempotencyToken] = scala
      .Option(impl.idempotencyToken())
      .map(value => zio.aws.acm.model.primitives.IdempotencyToken(value))
    override val domainValidationOptions
        : Option[List[zio.aws.acm.model.DomainValidationOption.ReadOnly]] =
      scala
        .Option(impl.domainValidationOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.DomainValidationOption.wrap(item)
          }.toList
        )
    override val options
        : Option[zio.aws.acm.model.CertificateOptions.ReadOnly] = scala
      .Option(impl.options())
      .map(value => zio.aws.acm.model.CertificateOptions.wrap(value))
    override val certificateAuthorityArn: Option[Arn] = scala
      .Option(impl.certificateAuthorityArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
    override val tags: Option[List[zio.aws.acm.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.RequestCertificateRequest
  ): zio.aws.acm.model.RequestCertificateRequest.ReadOnly = new Wrapper(impl)
}
