package zio.aws.acm.model
import scala.jdk.CollectionConverters._
sealed trait ValidationMethod {
  def unwrap: software.amazon.awssdk.services.acm.model.ValidationMethod
}
object ValidationMethod {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.ValidationMethod
  ): zio.aws.acm.model.ValidationMethod = value match {
    case software.amazon.awssdk.services.acm.model.ValidationMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.ValidationMethod.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.acm.model.ValidationMethod.DNS =>
      val r = DNS
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.ValidationMethod {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ValidationMethod =
      software.amazon.awssdk.services.acm.model.ValidationMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object EMAIL extends zio.aws.acm.model.ValidationMethod {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ValidationMethod =
      software.amazon.awssdk.services.acm.model.ValidationMethod.EMAIL
  }
  case object DNS extends zio.aws.acm.model.ValidationMethod {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ValidationMethod =
      software.amazon.awssdk.services.acm.model.ValidationMethod.DNS
  }
}
