package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class UpdateCertificateOptionsRequest(
    certificateArn: Arn,
    options: zio.aws.acm.model.CertificateOptions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.UpdateCertificateOptionsRequest = {
    import UpdateCertificateOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.UpdateCertificateOptionsRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .options(options.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.acm.model.UpdateCertificateOptionsRequest.ReadOnly =
    zio.aws.acm.model.UpdateCertificateOptionsRequest.wrap(buildAwsValue())
}
object UpdateCertificateOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.UpdateCertificateOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.UpdateCertificateOptionsRequest =
      zio.aws.acm.model
        .UpdateCertificateOptionsRequest(certificateArn, options.asEditable)
    def certificateArn: Arn
    def options: zio.aws.acm.model.CertificateOptions.ReadOnly
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
    def getOptions
        : ZIO[Any, Nothing, zio.aws.acm.model.CertificateOptions.ReadOnly] =
      ZIO.succeed(options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.UpdateCertificateOptionsRequest
  ) extends zio.aws.acm.model.UpdateCertificateOptionsRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
    override val options: zio.aws.acm.model.CertificateOptions.ReadOnly =
      zio.aws.acm.model.CertificateOptions.wrap(impl.options())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.UpdateCertificateOptionsRequest
  ): zio.aws.acm.model.UpdateCertificateOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
