package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTagsForCertificateResponse(
    tags: Optional[Iterable[zio.aws.acm.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ListTagsForCertificateResponse = {
    import ListTagsForCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ListTagsForCertificateResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ListTagsForCertificateResponse.ReadOnly =
    zio.aws.acm.model.ListTagsForCertificateResponse.wrap(buildAwsValue())
}
object ListTagsForCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ListTagsForCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ListTagsForCertificateResponse =
      zio.aws.acm.model.ListTagsForCertificateResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Optional[List[zio.aws.acm.model.Tag.ReadOnly]]
    def getTags: ZIO[Any, AwsError, List[zio.aws.acm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ListTagsForCertificateResponse
  ) extends zio.aws.acm.model.ListTagsForCertificateResponse.ReadOnly {
    override val tags: Optional[List[zio.aws.acm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ListTagsForCertificateResponse
  ): zio.aws.acm.model.ListTagsForCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
