package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResourceRecord(
    name: String,
    `type`: zio.aws.acm.model.RecordType,
    value: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ResourceRecord = {
    import ResourceRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ResourceRecord
      .builder()
      .name(name: java.lang.String)
      .`type`(`type`.unwrap)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ResourceRecord.ReadOnly =
    zio.aws.acm.model.ResourceRecord.wrap(buildAwsValue())
}
object ResourceRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ResourceRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ResourceRecord =
      zio.aws.acm.model.ResourceRecord(name, `type`, value)
    def name: String
    def `type`: zio.aws.acm.model.RecordType
    def value: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.acm.model.RecordType] =
      ZIO.succeed(`type`)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ResourceRecord
  ) extends zio.aws.acm.model.ResourceRecord.ReadOnly {
    override val name: String = impl.name(): String
    override val `type`: zio.aws.acm.model.RecordType =
      zio.aws.acm.model.RecordType.wrap(impl.`type`())
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ResourceRecord
  ): zio.aws.acm.model.ResourceRecord.ReadOnly = new Wrapper(impl)
}
