package zio.aws.acm.model
import scala.jdk.CollectionConverters.*
sealed trait CertificateTransparencyLoggingPreference {
  def unwrap: software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference
}
object CertificateTransparencyLoggingPreference {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference
  ): zio.aws.acm.model.CertificateTransparencyLoggingPreference = value match {
    case software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acm.model.CertificateTransparencyLoggingPreference {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference =
      software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.acm.model.CertificateTransparencyLoggingPreference {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference =
      software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference.ENABLED
  }
  case object DISABLED
      extends zio.aws.acm.model.CertificateTransparencyLoggingPreference {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference =
      software.amazon.awssdk.services.acm.model.CertificateTransparencyLoggingPreference.DISABLED
  }
}
