package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.IdempotencyToken
import scala.jdk.CollectionConverters.*
final case class PutAccountConfigurationRequest(
    expiryEvents: Option[zio.aws.acm.model.ExpiryEventsConfiguration] = None,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.PutAccountConfigurationRequest = {
    import PutAccountConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.PutAccountConfigurationRequest
      .builder()
      .optionallyWith(expiryEvents.map(value => value.buildAwsValue()))(
        _.expiryEvents
      )
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.acm.model.PutAccountConfigurationRequest.ReadOnly =
    zio.aws.acm.model.PutAccountConfigurationRequest.wrap(buildAwsValue())
}
object PutAccountConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.PutAccountConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.PutAccountConfigurationRequest =
      zio.aws.acm.model.PutAccountConfigurationRequest(
        expiryEvents.map(value => value.asEditable),
        idempotencyToken
      )
    def expiryEvents
        : Option[zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly]
    def idempotencyToken: IdempotencyToken
    def getExpiryEvents: ZIO[
      Any,
      AwsError,
      zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("expiryEvents", expiryEvents)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.PutAccountConfigurationRequest
  ) extends zio.aws.acm.model.PutAccountConfigurationRequest.ReadOnly {
    override val expiryEvents
        : Option[zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly] = scala
      .Option(impl.expiryEvents())
      .map(value => zio.aws.acm.model.ExpiryEventsConfiguration.wrap(value))
    override val idempotencyToken: IdempotencyToken =
      zio.aws.acm.model.primitives.IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.PutAccountConfigurationRequest
  ): zio.aws.acm.model.PutAccountConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
