package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class RequestCertificateResponse(
    certificateArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.RequestCertificateResponse = {
    import RequestCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.RequestCertificateResponse
      .builder()
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.RequestCertificateResponse.ReadOnly =
    zio.aws.acm.model.RequestCertificateResponse.wrap(buildAwsValue())
}
object RequestCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.RequestCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.RequestCertificateResponse =
      zio.aws.acm.model
        .RequestCertificateResponse(certificateArn.map(value => value))
    def certificateArn: Option[Arn]
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.RequestCertificateResponse
  ) extends zio.aws.acm.model.RequestCertificateResponse.ReadOnly {
    override val certificateArn: Option[Arn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.RequestCertificateResponse
  ): zio.aws.acm.model.RequestCertificateResponse.ReadOnly = new Wrapper(impl)
}
